/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.stats;

import com.sun.management.GarbageCollectionNotificationInfo;
import io.deephaven.base.stats.Counter;
import io.deephaven.base.stats.Stats;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.function.LongFunction;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

class GcEventStats
implements NotificationListener {
    private final Counter reclaimed = (Counter)Stats.makeItem((String)"Memory-GC", (String)"Reclaimed", (LongFunction)Counter.FACTORY).getValue();
    private final Counter allocated = (Counter)Stats.makeItem((String)"Memory", (String)"Allocated", (LongFunction)Counter.FACTORY).getValue();
    private long lastAfterGc = 0L;

    GcEventStats() {
    }

    public void install() {
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(bean instanceof NotificationBroadcaster)) continue;
            ((NotificationBroadcaster)((Object)bean)).addNotificationListener(this, null, null);
        }
    }

    public void remove() throws ListenerNotFoundException {
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(bean instanceof NotificationBroadcaster)) continue;
            ((NotificationBroadcaster)((Object)bean)).removeNotificationListener(this);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (!"com.sun.management.gc.notification".equals(notification.getType())) {
            return;
        }
        this.handleGCInfo(GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData()));
    }

    private synchronized void handleGCInfo(GarbageCollectionNotificationInfo info) {
        long beforeGc = info.getGcInfo().getMemoryUsageBeforeGc().values().stream().mapToLong(MemoryUsage::getUsed).sum();
        long afterGc = info.getGcInfo().getMemoryUsageAfterGc().values().stream().mapToLong(MemoryUsage::getUsed).sum();
        long reclaimedBytes = beforeGc - afterGc;
        this.reclaimed.increment(reclaimedBytes);
        long allocatedBytes = beforeGc - this.lastAfterGc;
        this.allocated.increment(allocatedBytes);
        this.lastAfterGc = afterGc;
    }
}

