/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalUtils {
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);

    public static BigDecimal sqrt(BigDecimal x, int scale) {
        BigDecimal difference;
        if (x == null) {
            return null;
        }
        if (x.signum() == 0) {
            return BigDecimal.ZERO;
        }
        if (x.signum() < 0) {
            throw new IllegalArgumentException("x=" + x + " is negative.");
        }
        if (scale < 0) {
            throw new IllegalArgumentException("scale=" + scale + " is negative.");
        }
        double intermediateInitial = Math.sqrt(x.doubleValue());
        double initial = Double.isFinite(intermediateInitial) ? intermediateInitial : Math.sqrt(Double.MAX_VALUE);
        BigDecimal epsilon = new BigDecimal(BigInteger.ONE, scale);
        BigDecimal x0 = BigDecimal.valueOf(initial);
        do {
            BigDecimal x1 = x0.add(x.divide(x0, scale, 4)).divide(TWO, scale, 4);
            difference = x1.subtract(x0).abs();
            x0 = x1;
        } while (difference.compareTo(epsilon) > 0);
        return x0;
    }
}

