/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.base.MathUtil;
import io.deephaven.base.string.EncodingInfo;
import io.deephaven.base.verify.Require;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class BufferUtil {
    public static ByteBuffer reallocateBuffer(@NotNull ByteBuffer buffer, int minimumSize) {
        int newCapacity = (int)Math.min(Integer.MAX_VALUE, 1L << MathUtil.ceilLog2((long)Math.max((long)minimumSize, (long)buffer.capacity() << 1)));
        ByteBuffer newBuffer = buffer.isDirect() ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity);
        newBuffer.put(buffer);
        return newBuffer;
    }

    public static ByteBuffer ensureSpace(ByteBuffer dataBuffer, int requiredSize) {
        int remainingCapacity = dataBuffer.capacity() - dataBuffer.position();
        if (remainingCapacity < requiredSize) {
            int newCapacity = Math.max(dataBuffer.capacity() > 0x100000 ? dataBuffer.capacity() + 0x100000 : dataBuffer.capacity() * 2, dataBuffer.capacity() + (requiredSize - remainingCapacity));
            ByteBuffer newBuffer = dataBuffer.isDirect() ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity);
            dataBuffer.flip();
            newBuffer.put(dataBuffer);
            dataBuffer = newBuffer;
        }
        Require.geq((int)(dataBuffer.capacity() - dataBuffer.position()), (String)"dataBuffer.capacity() - dataBuffer.position()", (int)requiredSize, (String)"requiredSize");
        return dataBuffer;
    }

    public static ByteBuffer writeUtf8(ByteBuffer dataBuffer, String value) {
        byte[] data = value.getBytes(EncodingInfo.UTF_8.getCharset());
        dataBuffer = BufferUtil.ensureSpace(dataBuffer, data.length + 4);
        dataBuffer.putInt(data.length);
        dataBuffer.put(data);
        return dataBuffer;
    }
}

