/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import org.jetbrains.annotations.NotNull;

public final class ExecutionContextRegistrationException
extends UncheckedDeephavenException {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionContextRegistrationException.class);

    public ExecutionContextRegistrationException(@NotNull String missingComponent) {
        super("No ExecutionContext registered, or current ExecutionContext has no " + missingComponent);
    }

    public static ExecutionContextRegistrationException onFailedComponentAccess(@NotNull String componentName) {
        logger.error().append((CharSequence)"No ExecutionContext registered, or current ExecutionContext has no ").append((CharSequence)componentName).append('.').append((CharSequence)" If this is being run in a thread, did you specify an ExecutionContext for the thread?").append((CharSequence)" Please refer to the documentation on ExecutionContext for details.").endl();
        return new ExecutionContextRegistrationException(componentName);
    }
}

