/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class FindExceptionCause {
    @SafeVarargs
    public static Exception findCause(Exception original, Class<? extends Exception> ... expectedTypes) {
        for (Throwable cause = original.getCause(); cause != null; cause = cause.getCause()) {
            Throwable checkCause = cause;
            if (!Arrays.stream(expectedTypes).anyMatch(type -> type.isAssignableFrom(checkCause.getClass()))) continue;
            return (Exception)cause;
        }
        return original;
    }

    @SafeVarargs
    public static Throwable findCause(Throwable original, Class<? extends Throwable> ... expectedTypes) {
        for (Throwable cause = original.getCause(); cause != null; cause = cause.getCause()) {
            Throwable checkCause = cause;
            if (!Arrays.stream(expectedTypes).anyMatch(type -> type.isAssignableFrom(checkCause.getClass()))) continue;
            return cause;
        }
        return original;
    }

    public static <E extends Throwable> Optional<E> isOrCausedBy(@NotNull Throwable original, @NotNull Class<E> expectedType) {
        for (Throwable cause = original; cause != null; cause = cause.getCause()) {
            if (!expectedType.isAssignableFrom(cause.getClass())) continue;
            return Optional.of(cause);
        }
        return Optional.empty();
    }

    public static String shortCauses(@NotNull Throwable throwable, String lineSeparator) {
        StringBuilder builder = new StringBuilder();
        while (throwable != null) {
            String cause = throwable.getMessage();
            if (builder.length() > 0) {
                builder.append(lineSeparator);
                builder.append("caused by ");
            }
            if (cause != null) {
                builder.append(cause);
            } else {
                builder.append(throwable.getClass().getName());
            }
            throwable = throwable.getCause();
        }
        return builder.toString();
    }

    @SafeVarargs
    public static Throwable findLastCause(Throwable original, Class<? extends Throwable> ... expectedTypes) {
        Throwable lastCause = original.getCause();
        for (Throwable cause = original.getCause(); cause != null; cause = cause.getCause()) {
            Throwable checkCause = cause;
            if (!Arrays.stream(expectedTypes).anyMatch(type -> type.isAssignableFrom(checkCause.getClass()))) continue;
            lastCause = cause;
        }
        return lastCause;
    }
}

