/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;

public class MultiException
extends Exception {
    public static final Throwable[] ZERO_LENGTH_THROWABLE_ARRAY = new Throwable[0];
    private final Throwable[] causes;

    public MultiException(String description, Throwable ... causes) {
        super(description, MultiException.getFirstCause(causes));
        this.causes = causes == null ? ZERO_LENGTH_THROWABLE_ARRAY : causes;
    }

    public static Throwable maybeWrapInMultiException(String description, Throwable ... causes) {
        if (causes.length == 1) {
            return causes[0];
        }
        return new MultiException(description, causes);
    }

    public static Throwable maybeWrapInMultiException(String description, List<? extends Throwable> causes) {
        if (causes.size() == 1) {
            return causes.get(0);
        }
        return new MultiException(description, causes.toArray(ZERO_LENGTH_THROWABLE_ARRAY));
    }

    public static Exception maybeWrapInMultiException(String description, Exception ... causes) {
        if (causes.length == 1) {
            return causes[0];
        }
        return new MultiException(description, causes);
    }

    private static Throwable getFirstCause(Throwable[] causes) {
        if (causes == null || causes.length == 0) {
            return null;
        }
        return causes[0];
    }

    public Throwable[] getCauses() {
        return this.causes;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        for (int i = 0; i < this.causes.length; ++i) {
            s.println("Cause " + (i + 1) + ":");
            this.causes[i].printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        for (int i = 0; i < this.causes.length; ++i) {
            s.println("Cause " + (i + 1) + ":");
            this.causes[i].printStackTrace(s);
        }
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage()).append(": \n");
        for (int i = 0; i < this.causes.length; ++i) {
            sb.append("Cause ").append(i).append(": ");
            sb.append(this.causes[i].toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

