/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.util.MultiException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SafeCloseable
extends AutoCloseable {
    public static void closeAll(SafeCloseable ... safeCloseables) {
        SafeCloseable.closeAll(Arrays.asList(safeCloseables).iterator());
    }

    public static <SCT extends SafeCloseable> void closeAll(@NotNull Stream<SCT> stream) {
        SafeCloseable.closeAll(stream.iterator());
    }

    public static <SCT extends SafeCloseable> void closeAll(@NotNull Iterator<SCT> iterator) {
        ArrayList<Exception> exceptions = null;
        while (iterator.hasNext()) {
            SafeCloseable safeCloseable = (SafeCloseable)iterator.next();
            if (safeCloseable == null) continue;
            try {
                safeCloseable.close();
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(e);
            }
        }
        if (exceptions != null) {
            throw new UncheckedDeephavenException("Exception while closing resources", MultiException.maybeWrapInMultiException("Close exceptions for multiple resources", exceptions));
        }
    }

    public static void closeIfNonNull(@Nullable SafeCloseable safeCloseable) {
        if (safeCloseable != null) {
            safeCloseable.close();
        }
    }

    @Override
    public void close();
}

