/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.util.MultiException;
import io.deephaven.util.SafeCloseable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SafeCloseableArray<SCT extends SafeCloseable>
implements SafeCloseable {
    private final SCT[] array;

    public SafeCloseableArray(SCT[] entries) {
        this.array = entries;
    }

    @Override
    public final void close() {
        SafeCloseableArray.close(this.array);
    }

    public static <SCT extends SafeCloseable> void close(@NotNull SCT[] array) {
        int length = array.length;
        ArrayList<Exception> exceptions = null;
        for (int ii = 0; ii < length; ++ii) {
            try (SCT ignored = array[ii];){
                array[ii] = null;
                continue;
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(e);
            }
        }
        if (exceptions != null) {
            throw new UncheckedDeephavenException("Exception while closing resources", MultiException.maybeWrapInMultiException("Close exceptions for multiple resources", (List<? extends Throwable>)exceptions));
        }
    }
}

