/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.util.SafeCloseable;
import io.deephaven.util.SafeCloseableArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeCloseableList
implements SafeCloseable {
    private final List<SafeCloseable> list = new ArrayList<SafeCloseable>();

    public SafeCloseableList() {
    }

    public SafeCloseableList(SafeCloseable ... entries) {
        this(Arrays.asList(entries));
    }

    public SafeCloseableList(Collection<SafeCloseable> entries) {
        this.list.addAll(entries);
    }

    public final void addAll(@NotNull List<SafeCloseable> closeableList) {
        this.list.addAll(closeableList);
    }

    public final <T extends SafeCloseable> T[] addArray(@Nullable T[] closeables) {
        if (closeables != null) {
            this.list.add(new SafeCloseableArray(closeables));
        }
        return closeables;
    }

    public final <T extends SafeCloseable> T add(T closeable) {
        this.list.add(closeable);
        return closeable;
    }

    public final void clear() {
        this.list.clear();
    }

    @Override
    public final void close() {
        for (SafeCloseable closeable : this.list) {
            if (closeable == null) continue;
            closeable.close();
        }
        this.list.clear();
    }
}

