/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import java.util.HashMap;

public final class SimpleTypeMap<V> {
    private final HashMap<Class<?>, V> map;
    private final V defaultValue;

    public static <V> SimpleTypeMap<V> create(V forBoolean, V forChar, V forByte, V forShort, V forInt, V forLong, V forFloat, V forDouble, V forObject) {
        HashMap<Class<Comparable<Boolean>>, V> map = new HashMap<Class<Comparable<Boolean>>, V>();
        map.put(Boolean.TYPE, forBoolean);
        map.put(Character.TYPE, forChar);
        map.put(Byte.TYPE, forByte);
        map.put(Short.TYPE, forShort);
        map.put(Integer.TYPE, forInt);
        map.put(Long.TYPE, forLong);
        map.put(Float.TYPE, forFloat);
        map.put(Double.TYPE, forDouble);
        return new SimpleTypeMap(map, forObject);
    }

    private SimpleTypeMap(HashMap<Class<?>, V> map, V defaultValue) {
        this.map = map;
        this.defaultValue = defaultValue;
    }

    public V get(Class<?> simpleType) {
        return this.map.getOrDefault(simpleType, this.defaultValue);
    }
}

