/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SoftRecycler<T> {
    private final int capacity;
    private final Supplier<T> constructItem;
    private final Consumer<T> sanitizeItem;
    private final List<SoftReferenceWithIndex<T>> recycleBin;
    private final ReferenceQueue<T> retirementQueue;

    public SoftRecycler(int capacity, Supplier<T> constructItem, Consumer<T> sanitizeItem) {
        this.capacity = capacity;
        this.constructItem = constructItem;
        this.sanitizeItem = sanitizeItem;
        this.recycleBin = new ArrayList<SoftReferenceWithIndex<T>>();
        this.retirementQueue = new ReferenceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrowItem() {
        SoftRecycler softRecycler = this;
        synchronized (softRecycler) {
            while (!this.recycleBin.isEmpty()) {
                Object item = this.recycleBin.remove(this.recycleBin.size() - 1).get();
                if (item == null) continue;
                return item;
            }
        }
        return this.constructItem.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnItem(T item) {
        if (this.sanitizeItem != null) {
            this.sanitizeItem.accept(item);
        }
        SoftRecycler softRecycler = this;
        synchronized (softRecycler) {
            this.cleanup();
            int size = this.recycleBin.size();
            if (size >= this.capacity) {
                return;
            }
            this.recycleBin.add(new SoftReferenceWithIndex<T>(item, this.retirementQueue, size));
        }
    }

    private void cleanup() {
        SoftReferenceWithIndex sri;
        while ((sri = (SoftReferenceWithIndex)this.retirementQueue.poll()) != null) {
            int destIndex = sri.index;
            if (destIndex >= this.recycleBin.size() || sri != this.recycleBin.get(destIndex)) continue;
            int lastIndex = this.recycleBin.size() - 1;
            SoftReferenceWithIndex<T> lastSri = this.recycleBin.remove(lastIndex);
            if (destIndex == lastIndex) continue;
            lastSri.index = destIndex;
            this.recycleBin.set(destIndex, lastSri);
        }
    }

    private static class SoftReferenceWithIndex<T>
    extends SoftReference<T> {
        private int index;

        SoftReferenceWithIndex(T referent, ReferenceQueue<? super T> q, int index) {
            super(referent, q);
            this.index = index;
        }
    }
}

