/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.util.codec.ObjectCodec;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigDecimalCodec
implements ObjectCodec<BigDecimal> {
    private final int precision;
    private final int scale;
    private final boolean strict;
    private int encodedSize;
    private byte[] zeroBytes;
    private byte[] nullBytes;
    public static final int MAX_FIXED_PRECISION = 1000;

    public BigDecimalCodec(int precision, int scale, boolean strict) {
        this.precision = precision;
        this.scale = scale;
        this.strict = strict;
        this.init();
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    public byte[] encodedNullValue() {
        return this.nullBytes;
    }

    public BigDecimalCodec(@Nullable String arguments) {
        try {
            int _precision = 0;
            int _scale = 0;
            boolean _strict = true;
            if (arguments != null && arguments.trim().length() > 0) {
                String[] tokens = arguments.split(",");
                if (tokens.length > 0 && tokens[0].trim().length() > 0 && (_precision = Integer.parseInt(tokens[0].trim())) < 1) {
                    throw new IllegalArgumentException("Specified precision must be >= 1");
                }
                if (tokens.length > 1 && tokens[1].trim().length() > 0) {
                    _scale = Integer.parseInt(tokens[1].trim());
                }
                if (tokens.length > 2 && tokens[2].trim().length() > 0) {
                    String mode = tokens[2].trim();
                    switch (mode.toLowerCase()) {
                        case "allowrounding": {
                            _strict = false;
                            break;
                        }
                        case "norounding": {
                            _strict = true;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected rounding mode (legal values are \"allowRounding\" or \"noRounding\"): " + mode);
                        }
                    }
                }
            }
            if (_precision < _scale) {
                throw new IllegalArgumentException("Precision must be >= scale");
            }
            this.precision = _precision;
            this.scale = _scale;
            this.strict = _strict;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error parsing codec argument(s): " + ex.getMessage(), ex);
        }
        this.init();
    }

    private void init() {
        if (this.precision < 0 || this.precision > 1000) {
            throw new IllegalArgumentException("Precision out of legal range (0-1000)");
        }
        if (this.scale < 0) {
            throw new IllegalArgumentException("Scale must be non-negative");
        }
        if (this.precision > 0) {
            this.encodedSize = (int)Math.ceil(Math.log(10.0) / Math.log(2.0) * (double)this.precision / 8.0) + 1;
            this.zeroBytes = new byte[this.encodedSize];
            Arrays.fill(this.zeroBytes, (byte)0);
            this.zeroBytes[0] = 1;
            this.nullBytes = new byte[this.encodedSize];
            Arrays.fill(this.nullBytes, (byte)-1);
            this.nullBytes[0] = 0;
        } else {
            this.encodedSize = 0;
            byte[] unscaledZero = BigDecimal.ZERO.unscaledValue().toByteArray();
            this.zeroBytes = new byte[4 + unscaledZero.length];
            Arrays.fill(this.zeroBytes, (byte)0);
            this.nullBytes = CollectionUtil.ZERO_LENGTH_BYTE_ARRAY;
        }
    }

    @Override
    @NotNull
    public byte[] encode(@Nullable BigDecimal input) {
        if (input == null) {
            return this.nullBytes;
        }
        BigDecimal value = input.stripTrailingZeros();
        if (this.precision == 0) {
            byte[] unscaledValue = value.unscaledValue().toByteArray();
            ByteBuffer buffer = ByteBuffer.allocate(unscaledValue.length + 4);
            buffer.putInt(value.scale());
            buffer.put(unscaledValue);
            return buffer.array();
        }
        if (value.precision() > this.precision || value.scale() > this.scale) {
            if (this.strict) {
                throw new IllegalArgumentException("Unable to encode value " + value.toString() + " with precision " + this.precision + " scale " + this.scale);
            }
            int targetPrecision = Math.min(this.precision, value.precision() - Math.max(0, value.scale() - this.scale));
            if (targetPrecision > 0) {
                value = value.round(new MathContext(targetPrecision));
            } else {
                return this.zeroBytes;
            }
        }
        byte[] bytes = new byte[this.encodedSize];
        bytes[0] = value.signum() >= 0 ? (byte)1 : 0;
        byte[] unscaledValue = (value = value.movePointRight(this.scale).setScale(0).abs()).unscaledValue().toByteArray();
        if (unscaledValue.length >= bytes.length) {
            throw new IllegalArgumentException("Value " + input.toString() + " is too large to encode with precision " + this.precision + " and scale " + this.scale);
        }
        Arrays.fill(bytes, 1, bytes.length, bytes[0] == 0 ? (byte)-1 : 0);
        if (bytes[0] == 0) {
            for (int i = 0; i < unscaledValue.length; ++i) {
                bytes[bytes.length - unscaledValue.length + i] = ~unscaledValue[i];
            }
        } else {
            System.arraycopy(unscaledValue, 0, bytes, bytes.length - unscaledValue.length, unscaledValue.length);
        }
        return bytes;
    }

    @Override
    @Nullable
    public BigDecimal decode(@NotNull byte[] input, int offset, int length) {
        boolean notNull;
        if (this.precision == 0) {
            if (length == 0) {
                return null;
            }
            ByteBuffer buffer = ByteBuffer.wrap(input, offset, length);
            int scale = buffer.getInt();
            byte[] unscaledValue = new byte[length - 4];
            buffer.get(unscaledValue);
            return new BigDecimal(new BigInteger(unscaledValue), scale);
        }
        byte[] unscaled = new byte[length - 1];
        boolean neg = input[offset] == 0;
        boolean bl = notNull = !neg;
        if (neg) {
            for (int i = 0; i < unscaled.length; ++i) {
                unscaled[i] = ~input[offset + i + 1];
                notNull = notNull || unscaled[i] != 0;
            }
        } else {
            System.arraycopy(input, offset + 1, unscaled, 0, length - 1);
        }
        if (!notNull) {
            return null;
        }
        BigInteger bi = neg ? new BigInteger(unscaled).negate() : new BigInteger(unscaled);
        return new BigDecimal(bi, this.scale, new MathContext(this.precision)).stripTrailingZeros();
    }

    @Override
    public int expectedObjectWidth() {
        return this.precision == 0 ? Integer.MIN_VALUE : this.encodedSize;
    }
}

