/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.util.codec.BigDecimalCodec;
import io.deephaven.util.codec.ObjectCodec;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigIntegerCodec
implements ObjectCodec<BigInteger> {
    private final BigDecimalCodec codec;
    public static final int MAX_FIXED_PRECISION = 1000;

    public BigIntegerCodec(int precision) {
        this.codec = new BigDecimalCodec(precision, 0, true);
    }

    public BigIntegerCodec(@Nullable String arguments) {
        try {
            int _precision = 0;
            if (arguments != null && arguments.trim().length() > 0 && (_precision = Integer.parseInt(arguments.trim())) < 1) {
                throw new IllegalArgumentException("Specified precision must be >= 1");
            }
            this.codec = new BigDecimalCodec(_precision, 0, true);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error parsing codec argument(s): " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public int getPrecision() {
        return this.codec.getPrecision();
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    @NotNull
    public byte[] encode(@Nullable BigInteger input) {
        return input == null ? this.codec.encodedNullValue() : this.codec.encode(new BigDecimal(input));
    }

    @Override
    @Nullable
    public BigInteger decode(@NotNull byte[] input, int offset, int length) {
        BigDecimal bd = this.codec.decode(input, offset, length);
        return bd == null ? null : bd.toBigInteger();
    }

    @Override
    public int expectedObjectWidth() {
        return this.codec.expectedObjectWidth();
    }
}

