/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.util.codec.ObjectCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalizableCodec<T extends Externalizable>
implements ObjectCodec<T> {
    private final Class<T> externalizableClass;

    public ExternalizableCodec(String className) {
        try {
            this.externalizableClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public byte[] encode(@Nullable T input) {
        if (input == null) {
            throw new UnsupportedOperationException(this.getClass() + " does not support null input");
        }
        try {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            input.writeExternal(objectOutput);
            objectOutput.flush();
            return byteOutput.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    @Nullable
    public T decode(@NotNull byte[] input, int offset, int length) {
        try {
            ByteArrayInputStream byteInput = new ByteArrayInputStream(input, offset, length);
            ObjectInputStream objectInput = new ObjectInputStream(byteInput);
            Externalizable result = (Externalizable)this.externalizableClass.newInstance();
            result.readExternal(objectInput);
            return (T)result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int expectedObjectWidth() {
        return Integer.MIN_VALUE;
    }
}

