/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.util.codec.ObjectCodec;
import java.time.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDateCodec
implements ObjectCodec<LocalDate> {
    private final Domain domain;
    private final byte[] nullBytes;
    private final int encodedSize;
    private final int minYear;
    private final int maxYear;
    private final byte NULL_INDICATOR = (byte)-1;

    public LocalDateCodec(@Nullable String arguments) {
        boolean nullable = true;
        if (arguments != null && !arguments.trim().isEmpty()) {
            String[] tokens = arguments.split(",");
            String domainStr = tokens[0].trim();
            try {
                this.domain = Domain.valueOf(domainStr);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unexpected value for LocalDate domain: " + domainStr);
            }
            if (tokens.length > 1) {
                String nullability = tokens[1].trim();
                switch (nullability.toLowerCase()) {
                    case "nullable": {
                        nullable = true;
                        break;
                    }
                    case "notnull": {
                        nullable = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value for nullability (legal values are \"nullable\" or \"notNull\"): " + nullability);
                    }
                }
            }
        } else {
            this.domain = Domain.Full;
        }
        switch (this.domain) {
            case Compact: {
                this.encodedSize = 3;
                this.minYear = 0;
                this.maxYear = 9999;
                break;
            }
            case Full: {
                this.encodedSize = 5;
                this.minYear = -999999999;
                this.maxYear = 999999999;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported domain: " + this.domain);
            }
        }
        if (nullable) {
            this.nullBytes = new byte[this.encodedSize];
            this.nullBytes[0] = -1;
        } else {
            this.nullBytes = null;
        }
    }

    @Override
    public boolean isNullable() {
        return this.nullBytes != null;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    @NotNull
    public byte[] encode(@Nullable LocalDate input) {
        if (input == null) {
            if (this.nullBytes != null) {
                return this.nullBytes;
            }
            throw new IllegalArgumentException("Codec cannot encode null LocalDate values");
        }
        if (input.getYear() < this.minYear || input.getYear() > this.maxYear) {
            throw new IllegalArgumentException("Year out of legal range [" + this.minYear + "," + this.maxYear + "] for " + this.domain.toString() + " encoder: " + input.getYear());
        }
        byte[] encodedValue = new byte[this.encodedSize];
        switch (this.domain) {
            case Compact: {
                int packedValue = input.getYear() << 9 | input.getMonthValue() << 5 | input.getDayOfMonth();
                for (int i = this.encodedSize - 1; i >= 0; --i) {
                    encodedValue[i] = (byte)(packedValue & 0xFF);
                    packedValue >>= 8;
                }
                break;
            }
            case Full: {
                long year = (long)input.getYear() - (long)this.minYear;
                long packedValue = year << 9 | (long)input.getMonthValue() << 5 | (long)input.getDayOfMonth();
                for (int i = this.encodedSize - 1; i >= 0; --i) {
                    encodedValue[i] = (byte)(packedValue & 0xFFL);
                    packedValue >>= 8;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported LocalDate encoding: " + this.domain);
            }
        }
        return encodedValue;
    }

    @Override
    @Nullable
    public LocalDate decode(@NotNull byte[] input, int offset, int length) {
        int dayOfMonth;
        int month;
        int year;
        if (input[offset] == -1) {
            return null;
        }
        switch (this.domain) {
            case Compact: {
                int packedValue = 0;
                for (int i = 0; i < this.encodedSize; ++i) {
                    packedValue <<= 8;
                    packedValue |= input[offset + i] & 0xFF;
                }
                year = packedValue >> 9;
                month = packedValue >> 5 & 0xF;
                dayOfMonth = packedValue & 0x1F;
                break;
            }
            case Full: {
                long packedValue = 0L;
                for (int i = 0; i < this.encodedSize; ++i) {
                    packedValue <<= 8;
                    packedValue |= (long)(input[offset + i] & 0xFF);
                }
                year = (int)(packedValue >> 9) + this.minYear;
                month = (int)(packedValue >> 5 & 0xFL);
                dayOfMonth = (int)(packedValue & 0x1FL);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported LocalDate encoding: " + this.domain);
            }
        }
        return LocalDate.of(year, month, dayOfMonth);
    }

    @Override
    public int expectedObjectWidth() {
        return this.encodedSize;
    }

    public static enum Domain {
        Full,
        Compact;

    }
}

