/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.util.codec.ObjectCodec;
import java.time.LocalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalTimeCodec
implements ObjectCodec<LocalTime> {
    private final int precision;
    private final int fractionalBits;
    private final int encodedSize;
    private final byte[] nullBytes;
    private final byte NULL_INDICATOR = (byte)-128;

    public LocalTimeCodec(@Nullable String arguments) {
        boolean nullable = true;
        if (arguments != null && !arguments.trim().isEmpty()) {
            try {
                String[] tokens = arguments.split(",");
                this.precision = Integer.parseInt(tokens[0].trim());
                if (tokens.length > 1) {
                    String nullability = tokens[1].trim();
                    switch (nullability.toLowerCase()) {
                        case "nullable": {
                            nullable = true;
                            break;
                        }
                        case "notnull": {
                            nullable = false;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected value for nullability (legal values are \"nullable\" or \"notNull\"): " + nullability);
                        }
                    }
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Error fractional second precision: " + ex.getMessage(), ex);
            }
            if (this.precision < 0 || this.precision > 9) {
                throw new IllegalArgumentException("Invalid fractional second precision: " + this.precision);
            }
        } else {
            this.precision = 9;
        }
        this.fractionalBits = (int)Math.ceil(Math.log(10.0) / Math.log(2.0) * (double)this.precision);
        int encodedBits = 17 + this.fractionalBits;
        if (nullable) {
            ++encodedBits;
        }
        this.encodedSize = (int)Math.ceil((double)encodedBits / 8.0);
        if (nullable) {
            this.nullBytes = new byte[this.encodedSize];
            this.nullBytes[0] = -128;
        } else {
            this.nullBytes = null;
        }
    }

    @Override
    public boolean isNullable() {
        return this.nullBytes != null;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    @NotNull
    public byte[] encode(@Nullable LocalTime input) {
        if (input == null) {
            if (this.nullBytes != null) {
                return this.nullBytes;
            }
            throw new IllegalArgumentException("Codec cannot encode null time values");
        }
        byte[] encodedValue = new byte[this.encodedSize];
        long fractionalSecond = (long)((double)input.getNano() / Math.pow(10.0, 9 - this.precision));
        long packedValue = (long)input.getHour() << 12 + this.fractionalBits | (long)input.getMinute() << 6 + this.fractionalBits | (long)input.getSecond() << this.fractionalBits | fractionalSecond;
        for (int i = this.encodedSize - 1; i >= 0; --i) {
            encodedValue[i] = (byte)(packedValue & 0xFFL);
            packedValue >>= 8;
        }
        return encodedValue;
    }

    @Override
    @Nullable
    public LocalTime decode(@NotNull byte[] input, int offset, int length) {
        if ((input[offset] & 0xFFFFFF80) != 0) {
            return null;
        }
        long packedValue = 0L;
        for (int i = 0; i < this.encodedSize; ++i) {
            packedValue <<= 8;
            packedValue |= (long)(input[i + offset] & 0xFF);
        }
        int hour = (int)(packedValue >> 12 + this.fractionalBits);
        int minute = (int)(packedValue >> 6 + this.fractionalBits & 0x3FL);
        int second = (int)(packedValue >> this.fractionalBits & 0x3FL);
        int fractionalSecond = (int)(packedValue & (long)((int)Math.pow(2.0, this.fractionalBits) - 1));
        int nano = fractionalSecond * (int)Math.pow(10.0, 9 - this.precision);
        return LocalTime.of(hour, minute, second, nano);
    }

    @Override
    public int expectedObjectWidth() {
        return this.encodedSize;
    }
}

