/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.util.codec.ObjectCodec;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MapCodec<K, V>
implements ObjectCodec<Map<K, V>> {
    private static final byte[] nullBytes = CollectionUtil.ZERO_LENGTH_BYTE_ARRAY;
    private static final byte[] zeroBytes = new byte[4];
    private static final int MINIMUM_SCRATCH_CAPACITY = 4096;
    private static final ThreadLocal<SoftReference<ByteBuffer>> scratchBufferThreadLocal = ThreadLocal.withInitial(() -> new SoftReference<ByteBuffer>(ByteBuffer.allocate(4096)));

    MapCodec(@Nullable String arguments) {
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    @NotNull
    public byte[] encode(@Nullable Map<K, V> input) {
        if (input == null) {
            return nullBytes;
        }
        if (input.size() == 0) {
            return zeroBytes;
        }
        ByteBuffer holdScratch = scratchBufferThreadLocal.get().get();
        if (holdScratch == null) {
            holdScratch = this.allocateScratch(Math.max(this.estimateSize(input), 4096));
        }
        Buffer scratch = null;
        int estimatedCapacity = -1;
        for (int tryCount = 0; tryCount < 4; ++tryCount) {
            try {
                scratch = this.encodeIntoBuffer(holdScratch, input);
                continue;
            }
            catch (BufferUnderflowException bue) {
                estimatedCapacity = estimatedCapacity < 0 ? this.estimateSize(input) : (estimatedCapacity *= 2);
                holdScratch = this.allocateScratch(estimatedCapacity);
            }
        }
        if (scratch == null) {
            throw new BufferUnderflowException();
        }
        byte[] bytes = new byte[scratch.position()];
        ((ByteBuffer)scratch).flip();
        ((ByteBuffer)scratch).get(bytes);
        return bytes;
    }

    private ByteBuffer allocateScratch(int estimatedCapacity) {
        ByteBuffer holdScratch = ByteBuffer.allocate(estimatedCapacity);
        scratchBufferThreadLocal.set(new SoftReference<ByteBuffer>(holdScratch));
        return holdScratch;
    }

    private ByteBuffer encodeIntoBuffer(ByteBuffer scratch, @NotNull Map<K, V> input) {
        scratch.clear();
        scratch.putInt(input.size());
        for (Map.Entry<K, V> entry : input.entrySet()) {
            this.encodeKey(scratch, entry.getKey());
            this.encodeValue(scratch, entry.getValue());
        }
        return scratch;
    }

    @Override
    @Nullable
    public Map<K, V> decode(@NotNull byte[] input, int offset, int length) {
        if (input.length == 0) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(input);
        int size = byteBuffer.getInt();
        if (size == 0) {
            return Collections.emptyMap();
        }
        if (size == 1) {
            K key = this.decodeKey(byteBuffer);
            V value = this.decodeValue(byteBuffer);
            return Collections.singletonMap(key, value);
        }
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>(size);
        for (int ii = 0; ii < size; ++ii) {
            result.put(this.decodeKey(byteBuffer), this.decodeValue(byteBuffer));
        }
        return Collections.unmodifiableMap(result);
    }

    abstract int estimateSize(Map<K, V> var1);

    abstract K decodeKey(ByteBuffer var1);

    abstract V decodeValue(ByteBuffer var1);

    abstract void encodeKey(ByteBuffer var1, K var2);

    abstract void encodeValue(ByteBuffer var1, V var2);

    @Override
    public int expectedObjectWidth() {
        return Integer.MIN_VALUE;
    }
}

