/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.util.codec.ObjectCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableCodec<T>
implements ObjectCodec<T> {
    private static final SerializableCodec INSTANCE = new SerializableCodec();

    public static <T> SerializableCodec<T> create() {
        return INSTANCE;
    }

    private SerializableCodec() {
    }

    public SerializableCodec(String dummy) {
    }

    @Override
    @NotNull
    public byte[] encode(@Nullable T input) {
        try {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeObject(input);
            objectOutput.flush();
            return byteOutput.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    @Nullable
    public T decode(@NotNull byte[] input, int offset, int length) {
        try {
            ByteArrayInputStream byteInput = new ByteArrayInputStream(input, offset, length);
            ObjectInputStream objectInput = new ObjectInputStream(byteInput);
            return (T)objectInput.readObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int expectedObjectWidth() {
        return Integer.MIN_VALUE;
    }
}

