/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.util.codec.ObjectCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleByteArrayCodec
implements ObjectCodec<byte[]> {
    private final int expectedWidth;

    public SimpleByteArrayCodec(@Nullable String arguments) {
        int size;
        if (arguments == null || arguments.trim().isEmpty()) {
            this.expectedWidth = Integer.MIN_VALUE;
            return;
        }
        String[] tokens = arguments.split(",");
        if (tokens.length == 0) {
            this.expectedWidth = Integer.MIN_VALUE;
            return;
        }
        try {
            size = Integer.parseInt(tokens[0].trim());
            if (tokens.length > 1) {
                throw new IllegalArgumentException("Unexpected additional arguments after first: " + arguments);
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Error parsing column size: " + ex.getMessage(), ex);
        }
        if (size < 1) {
            throw new IllegalArgumentException("Invalid column size: " + size);
        }
        this.expectedWidth = size;
    }

    @Override
    @NotNull
    public byte[] encode(@Nullable byte[] input) {
        if (input == null) {
            throw new IllegalArgumentException(SimpleByteArrayCodec.class.getSimpleName() + " cannot encode nulls");
        }
        return input;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    @Nullable
    public byte[] decode(@NotNull byte[] input, int offset, int length) {
        if (input.length == 0) {
            return CollectionUtil.ZERO_LENGTH_BYTE_ARRAY;
        }
        if (offset == 0 && length == input.length) {
            return input;
        }
        byte[] output = new byte[length];
        System.arraycopy(input, offset, output, 0, length);
        return output;
    }

    @Override
    public int expectedObjectWidth() {
        return this.expectedWidth;
    }
}

