/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.util.codec.StringKeyedMapCodec;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;

public class StringFloatMapCodec
extends StringKeyedMapCodec<Float> {
    public StringFloatMapCodec(@Nullable String arguments) {
        super(arguments);
    }

    @Override
    int getValueSize() {
        return 4;
    }

    @Override
    Float decodeValue(ByteBuffer byteBuffer) {
        float value = byteBuffer.getFloat();
        return value == -3.4028235E38f ? null : Float.valueOf(value);
    }

    @Override
    void encodeValue(ByteBuffer scratch, Float value) {
        scratch.putFloat(value == null ? -3.4028235E38f : value.floatValue());
    }
}

