/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.util.EncodingUtil;
import io.deephaven.util.codec.MapCodec;
import java.nio.ByteBuffer;
import java.util.Map;

abstract class StringKeyedMapCodec<V>
extends MapCodec<String, V> {
    StringKeyedMapCodec(String arguments) {
        super(arguments);
    }

    @Override
    int estimateSize(Map<String, V> input) {
        int estimate = 0;
        for (String key : input.keySet()) {
            estimate += key.length() + 4;
        }
        estimate = (int)((double)estimate * 1.1);
        return estimate += 4 + this.getValueSize() * input.size();
    }

    abstract int getValueSize();

    @Override
    String decodeKey(ByteBuffer byteBuffer) {
        return EncodingUtil.getUtf8String(byteBuffer);
    }

    @Override
    void encodeKey(ByteBuffer scratch, String key) {
        EncodingUtil.putUtf8String(scratch, key);
    }
}

