/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.compare;

public class DoubleComparisons {
    public static int compare(double lhs, double rhs) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == -1.7976931348623157E308) {
            return -1;
        }
        if (rhs == -1.7976931348623157E308) {
            return 1;
        }
        if (Double.isNaN(lhs)) {
            if (Double.isNaN(rhs)) {
                return 0;
            }
            return 1;
        }
        if (Double.isNaN(rhs)) {
            return -1;
        }
        return lhs < rhs ? -1 : 1;
    }

    public static boolean eq(double lhs, double rhs) {
        return Double.isNaN(lhs) && Double.isNaN(rhs) || lhs == rhs;
    }

    public static boolean gt(double lhs, double rhs) {
        return DoubleComparisons.compare(lhs, rhs) > 0;
    }

    public static boolean lt(double lhs, double rhs) {
        return DoubleComparisons.compare(lhs, rhs) < 0;
    }

    public static boolean geq(double lhs, double rhs) {
        return DoubleComparisons.compare(lhs, rhs) >= 0;
    }

    public static boolean leq(double lhs, double rhs) {
        return DoubleComparisons.compare(lhs, rhs) <= 0;
    }
}

