/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import java.lang.ref.SoftReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class LazyCachingFunction<INPUT_TYPE, OUTPUT_TYPE>
implements Function<INPUT_TYPE, OUTPUT_TYPE> {
    private final Function<INPUT_TYPE, OUTPUT_TYPE> internalFunction;
    private volatile SoftReference<OUTPUT_TYPE> cachedResultRef;

    public LazyCachingFunction(@NotNull Function<INPUT_TYPE, OUTPUT_TYPE> internalFunction) {
        this.internalFunction = internalFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUTPUT_TYPE apply(INPUT_TYPE arg) {
        OUTPUT_TYPE current;
        SoftReference<OUTPUT_TYPE> currentRef = this.cachedResultRef;
        if (currentRef != null && (current = currentRef.get()) != null) {
            return current;
        }
        LazyCachingFunction lazyCachingFunction = this;
        synchronized (lazyCachingFunction) {
            currentRef = this.cachedResultRef;
            if (currentRef != null && (current = currentRef.get()) != null) {
                return current;
            }
            current = this.internalFunction.apply(arg);
            this.cachedResultRef = new SoftReference<OUTPUT_TYPE>(current);
        }
        return current;
    }
}

