/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import java.lang.ref.SoftReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class LazyCachingSupplier<OUTPUT_TYPE>
implements Supplier<OUTPUT_TYPE> {
    private final Supplier<OUTPUT_TYPE> internalSupplier;
    private volatile SoftReference<OUTPUT_TYPE> cachedResultRef;

    public LazyCachingSupplier(@NotNull Supplier<OUTPUT_TYPE> internalSupplier) {
        this.internalSupplier = internalSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUTPUT_TYPE get() {
        OUTPUT_TYPE current;
        SoftReference<OUTPUT_TYPE> currentRef = this.cachedResultRef;
        if (currentRef != null && (current = currentRef.get()) != null) {
            return current;
        }
        LazyCachingSupplier lazyCachingSupplier = this;
        synchronized (lazyCachingSupplier) {
            currentRef = this.cachedResultRef;
            if (currentRef != null && (current = currentRef.get()) != null) {
                return current;
            }
            current = this.internalSupplier.get();
            this.cachedResultRef = new SoftReference<OUTPUT_TYPE>(current);
        }
        return current;
    }
}

