/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import io.deephaven.util.datastructures.SizeException;
import org.jetbrains.annotations.NotNull;

public interface LongSizedDataStructure {
    public long size();

    default public int intSize() {
        return this.intSize("int cast");
    }

    default public int intSize(@NotNull String operation) {
        return LongSizedDataStructure.intSize(operation, this.size());
    }

    public static int intSize(@NotNull String operation, long size) {
        if (size <= Integer.MAX_VALUE) {
            return (int)size;
        }
        throw new SizeException(operation + " cannot proceed without losing precision", size);
    }
}

