/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import io.deephaven.configuration.Configuration;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public interface ReleaseTracker<RESOURCE_TYPE> {
    public static final boolean CAPTURE_STACK_TRACES = Configuration.getInstance().getBooleanForClassWithDefault(ReleaseTracker.class, "captureStackTraces", false);
    public static final Factory strictReleaseTrackerFactory = new Factory(){

        @Override
        public ReleaseTracker makeReleaseTracker() {
            return new StrictReleaseTracker();
        }

        @Override
        public boolean isMyType(Class type) {
            return type == StrictReleaseTracker.class;
        }
    };
    public static final Factory weakReleaseTrackerFactory = new Factory(){

        @Override
        public ReleaseTracker makeReleaseTracker() {
            return new WeakReleaseTracker();
        }

        @Override
        public boolean isMyType(Class type) {
            return type == WeakReleaseTracker.class;
        }
    };

    public void reportAcquire(@NotNull RESOURCE_TYPE var1);

    public void reportRelease(@NotNull RESOURCE_TYPE var1);

    public void check();

    public static void append(StringBuilder sb, String prefix, StackTraceElement[] es) {
        for (int i = 1; i < es.length; ++i) {
            sb.append(prefix).append(es[i].toString()).append("\n");
        }
    }

    public static class AlreadyReleasedException
    extends RuntimeException {
        private static String build(@NotNull StackTraceElement[] newRelease, @NotNull StackTraceElement[] lastAcquire, @NotNull StackTraceElement[] lastRelease) {
            if (newRelease.length == 0) {
                return "Already released resource is being re-released. Enable `ReleaseTracker.captureStackTraces` to further debug.";
            }
            StringBuilder sb = new StringBuilder("Already released resource is being re-released:\n");
            sb.append("    New release:\n");
            ReleaseTracker.append(sb, "        ", newRelease);
            sb.append("    Last release:\n");
            ReleaseTracker.append(sb, "        ", lastRelease);
            sb.append("    Last acquire:\n");
            ReleaseTracker.append(sb, "        ", lastAcquire);
            return sb.toString();
        }

        private AlreadyReleasedException(@NotNull StackTraceElement[] newRelease, @NotNull StackTraceElement[] lastAcquire, @NotNull StackTraceElement[] lastRelease) {
            super(AlreadyReleasedException.build(newRelease, lastAcquire, lastRelease));
        }
    }

    public static class AlreadyAcquiredException
    extends RuntimeException {
        private static String build(@NotNull StackTraceElement[] newAcquire, @NotNull StackTraceElement[] existingAcquire) {
            if (newAcquire.length == 0) {
                return "Already acquired resource is being re-acquired without intervening release. Enable `ReleaseTracker.captureStackTraces` to further debug.";
            }
            StringBuilder sb = new StringBuilder("Already acquired resource is being re-acquired without intervening release:\n");
            sb.append("    New acquire:\n");
            ReleaseTracker.append(sb, "        ", newAcquire);
            sb.append("    Existing acquire:\n");
            ReleaseTracker.append(sb, "        ", existingAcquire);
            return sb.toString();
        }

        private AlreadyAcquiredException(@NotNull StackTraceElement[] newAcquire, @NotNull StackTraceElement[] existingAcquire) {
            super(AlreadyAcquiredException.build(newAcquire, existingAcquire));
        }
    }

    public static class LeakedException
    extends RuntimeException {
        private LeakedException(@NotNull UnmatchedAcquireException cause) {
            super("Leaked resource", cause);
        }

        private static String build(@NotNull Collection<StackTraceElement[]> leaks) {
            long maxUniqueTraces = 100L;
            StringBuilder stackTrace = new StringBuilder();
            LinkedHashMap<String, Long> dupDetector = new LinkedHashMap<String, Long>();
            for (StackTraceElement[] leak : leaks) {
                stackTrace.setLength(0);
                ReleaseTracker.append(stackTrace, "        ", leak);
                String stackTraceString = stackTrace.toString();
                dupDetector.put(stackTraceString, 1L + dupDetector.getOrDefault(stackTraceString, 0L));
            }
            StringBuilder sb = new StringBuilder("Leaked " + leaks.size() + " resources (" + dupDetector.size() + " unique traces):\n");
            MutableInt i = new MutableInt();
            dupDetector.entrySet().stream().limit(100L).forEach(entry -> {
                sb.append("    Leak #").append(i.intValue());
                if ((Long)entry.getValue() > 0L) {
                    sb.append(", detected " + entry.getValue() + " times, was acquired:\n");
                } else {
                    sb.append(" was acquired:\n");
                }
                i.increment();
                sb.append((String)entry.getKey());
            });
            if ((long)dupDetector.size() > 100L) {
                sb.append("    [ ... ]");
            }
            return sb.toString();
        }

        private LeakedException(@NotNull Collection<StackTraceElement[]> leaked) {
            super(LeakedException.build(leaked));
        }

        private LeakedException(long numLeaks) {
            super("Leaked " + numLeaks + " resources. Enable `ReleaseTracker.captureStackTraces` to further debug.");
        }
    }

    public static class MissedReleaseException
    extends RuntimeException {
        private MissedReleaseException(@NotNull UnmatchedAcquireException cause) {
            super("Missed release for resource", cause);
        }
    }

    public static class UnmatchedAcquireException
    extends RuntimeException {
        private UnmatchedAcquireException() {
            super("Resource lastAcquireMap without release");
        }

        private static String builder(@NotNull StackTraceElement[] release) {
            StringBuilder sb = new StringBuilder("Release with no prior acquire:\n");
            ReleaseTracker.append(sb, "    ", release);
            return sb.toString();
        }

        private UnmatchedAcquireException(@NotNull StackTraceElement[] release) {
            super(UnmatchedAcquireException.builder(release));
        }
    }

    public static class WeakReleaseTracker<RESOURCE_TYPE>
    implements ReleaseTracker<RESOURCE_TYPE> {
        private final Map<RESOURCE_TYPE, Cookie> outstandingCookies = Collections.synchronizedMap(new WeakHashMap());
        private final ReferenceQueue<RESOURCE_TYPE> collectedCookies = new ReferenceQueue();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void check() {
            Cookie cookie;
            System.gc();
            while ((cookie = (Cookie)this.collectedCookies.poll()) != null) {
                cookie.collected();
            }
            Map<RESOURCE_TYPE, Cookie> map = this.outstandingCookies;
            synchronized (map) {
                this.outstandingCookies.values().forEach(rec$ -> ((Cookie)rec$).presentOnCheck());
                this.outstandingCookies.clear();
            }
        }

        @Override
        public final void reportAcquire(@NotNull RESOURCE_TYPE resource) {
            this.outstandingCookies.put(resource, new Cookie(resource));
        }

        @Override
        public final void reportRelease(@NotNull RESOURCE_TYPE resource) {
            this.outstandingCookies.remove(resource).released();
        }

        private final class Cookie
        extends WeakReference<RESOURCE_TYPE> {
            private UnmatchedAcquireException pendingAcquireException;
            private boolean released;

            private Cookie(RESOURCE_TYPE referent) {
                super(referent, WeakReleaseTracker.this.collectedCookies);
                this.pendingAcquireException = new UnmatchedAcquireException();
                this.released = false;
            }

            private synchronized void released() {
                this.released = true;
                this.pendingAcquireException = null;
            }

            private synchronized void collected() {
                if (!this.released) {
                    throw new LeakedException(this.pendingAcquireException);
                }
            }

            private synchronized void presentOnCheck() {
                try {
                    throw new MissedReleaseException(this.pendingAcquireException);
                }
                catch (Throwable throwable) {
                    this.released();
                    throw throwable;
                }
            }
        }
    }

    public static class StrictReleaseTracker<RESOURCE_TYPE>
    implements ReleaseTracker<RESOURCE_TYPE> {
        private static final StackTraceElement[] ZERO_ELEMENT_STACK_TRACE_ARRAY = new StackTraceElement[0];
        private final Map<RESOURCE_TYPE, StackTraceElement[]> lastAcquireMap = new HashMap<RESOURCE_TYPE, StackTraceElement[]>();
        private final Map<RESOURCE_TYPE, LastAcquireAndReleaseInfo> lastAcquireAndReleaseMap = new WeakHashMap<RESOURCE_TYPE, LastAcquireAndReleaseInfo>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void reportAcquire(@NotNull RESOURCE_TYPE resource) {
            StackTraceElement[] stackTrace = CAPTURE_STACK_TRACES ? Thread.currentThread().getStackTrace() : ZERO_ELEMENT_STACK_TRACE_ARRAY;
            StrictReleaseTracker strictReleaseTracker = this;
            synchronized (strictReleaseTracker) {
                StackTraceElement[] prev = this.lastAcquireMap.put(resource, stackTrace);
                if (prev != null) {
                    throw new AlreadyAcquiredException(stackTrace, prev);
                }
                this.lastAcquireAndReleaseMap.remove(resource);
            }
        }

        @Override
        public final void reportRelease(@NotNull RESOURCE_TYPE resource) {
            StackTraceElement[] stackTrace = CAPTURE_STACK_TRACES ? Thread.currentThread().getStackTrace() : ZERO_ELEMENT_STACK_TRACE_ARRAY;
            StrictReleaseTracker strictReleaseTracker = this;
            synchronized (strictReleaseTracker) {
                StackTraceElement[] prev = this.lastAcquireMap.remove(resource);
                if (prev != null) {
                    this.lastAcquireAndReleaseMap.put(resource, new LastAcquireAndReleaseInfo(prev, stackTrace));
                    return;
                }
                LastAcquireAndReleaseInfo lastAcquireAndRelease = this.lastAcquireAndReleaseMap.get(resource);
                if (lastAcquireAndRelease != null) {
                    throw new AlreadyReleasedException(stackTrace, lastAcquireAndRelease.lastAcquire, lastAcquireAndRelease.lastRelease);
                }
                throw new UnmatchedAcquireException(stackTrace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void check() {
            StrictReleaseTracker strictReleaseTracker = this;
            synchronized (strictReleaseTracker) {
                int leakedCount = this.lastAcquireMap.size();
                if (leakedCount > 0) {
                    LeakedException leakedException = CAPTURE_STACK_TRACES ? new LeakedException(this.lastAcquireMap.values()) : new LeakedException(leakedCount);
                    this.lastAcquireMap.clear();
                    throw leakedException;
                }
            }
        }

        private static final class LastAcquireAndReleaseInfo {
            private final StackTraceElement[] lastAcquire;
            private final StackTraceElement[] lastRelease;

            private LastAcquireAndReleaseInfo(StackTraceElement[] lastAcquire, StackTraceElement[] lastRelease) {
                this.lastAcquire = lastAcquire;
                this.lastRelease = lastRelease;
            }
        }
    }

    public static interface Factory {
        public ReleaseTracker makeReleaseTracker();

        public boolean isMyType(Class var1);
    }
}

