/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import io.deephaven.base.reference.SimpleReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleReferenceManager<T, R extends SimpleReference<T>> {
    private final Function<T, R> referenceFactory;
    private final Collection<R> references;

    public SimpleReferenceManager(@NotNull Function<T, R> referenceFactory) {
        this(referenceFactory, true);
    }

    public SimpleReferenceManager(@NotNull Function<T, R> referenceFactory, boolean concurrent) {
        this(referenceFactory, concurrent ? new CopyOnWriteArrayList() : new ArrayList());
    }

    public SimpleReferenceManager(@NotNull Function<T, R> referenceFactory, @NotNull Collection<R> referenceCollection) {
        this.referenceFactory = referenceFactory;
        this.references = referenceCollection;
    }

    public R add(@NotNull T item) {
        SimpleReference ref = (SimpleReference)this.referenceFactory.apply(item);
        this.references.add(ref);
        return (R)ref;
    }

    public T remove(@NotNull T item) {
        return (T)(this.removeIf(found -> found == item) ? item : null);
    }

    public void removeAll(@NotNull Collection<T> items) {
        this.removeIf(items::contains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIf(@NotNull Predicate<T> filter) {
        if (this.references.isEmpty()) {
            return false;
        }
        Deque<R> collected = null;
        boolean found = false;
        try {
            for (SimpleReference ref : this.references) {
                Object item = ref.get();
                boolean accepted = false;
                if (item == null || (accepted = filter.test(item))) {
                    ref.clear();
                    collected = this.maybeMakeRemovalDeque(collected);
                    collected.add(ref);
                }
                found |= accepted;
            }
        }
        finally {
            this.maybeDoRemoves(collected);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(@NotNull BiConsumer<R, T> consumer) {
        if (this.references.isEmpty()) {
            return;
        }
        Deque<R> collected = null;
        try {
            for (SimpleReference ref : this.references) {
                Object item = ref.get();
                if (item != null) {
                    consumer.accept((R)ref, (SimpleReference)item);
                    continue;
                }
                collected = this.maybeMakeRemovalDeque(collected);
                collected.add(ref);
            }
        }
        finally {
            this.maybeDoRemoves(collected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getFirstItem(@NotNull Predicate<T> filter) {
        if (this.references.isEmpty()) {
            return null;
        }
        Deque<R> collected = null;
        try {
            for (SimpleReference ref : this.references) {
                Object item = ref.get();
                if (item != null) {
                    if (!filter.test(item)) continue;
                    Object object = item;
                    return (T)object;
                }
                collected = this.maybeMakeRemovalDeque(collected);
                collected.add(ref);
            }
        }
        finally {
            this.maybeDoRemoves(collected);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R getFirstReference(@NotNull Predicate<T> filter) {
        if (this.references.isEmpty()) {
            return null;
        }
        Deque<R> collected = null;
        try {
            for (SimpleReference ref : this.references) {
                Object item = ref.get();
                if (item != null) {
                    if (!filter.test(item)) continue;
                    SimpleReference simpleReference = ref;
                    return (R)simpleReference;
                }
                collected = this.maybeMakeRemovalDeque(collected);
                collected.add(ref);
            }
        }
        finally {
            this.maybeDoRemoves(collected);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.references.isEmpty();
    }

    public int size() {
        MutableInt size = new MutableInt(0);
        this.forEach((ref, source) -> size.increment());
        return size.intValue();
    }

    public void clear() {
        this.references.clear();
    }

    private Deque<R> maybeMakeRemovalDeque(@Nullable Deque<R> current) {
        if (current != null) {
            return current;
        }
        return new ArrayDeque<R>(){

            @Override
            public boolean contains(Object object) {
                if (this.peekFirst() == object) {
                    this.pollFirst();
                    return true;
                }
                return false;
            }
        };
    }

    private void maybeDoRemoves(@Nullable Deque<R> toRemove) {
        if (toRemove == null || toRemove.isEmpty()) {
            return;
        }
        if (toRemove.size() == 1) {
            this.references.remove(toRemove.peekFirst());
        } else {
            this.references.removeAll(toRemove);
        }
    }
}

