/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import io.deephaven.hash.IndexableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SortedIndexableMapWrapper<K, V>
implements IndexableMap<K, V> {
    private final Map<K, V> baseMap;
    private final Comparator<V> comparator;
    private ArrayList<Map.Entry<K, V>> valueList;

    public SortedIndexableMapWrapper(Map<K, V> baseMap, Comparator<V> comparator) {
        this.baseMap = baseMap;
        this.comparator = comparator;
        this.valueList = null;
    }

    private synchronized void clearList() {
        this.valueList = null;
    }

    private synchronized List<Map.Entry<K, V>> getValuesList() {
        if (this.valueList != null) {
            return this.valueList;
        }
        this.valueList = this.baseMap.entrySet().stream().sorted((e1, e2) -> this.comparator.compare(e1.getValue(), e2.getValue())).collect(Collectors.toCollection(ArrayList::new));
        return this.valueList;
    }

    public int size() {
        return this.baseMap.size();
    }

    public boolean isEmpty() {
        return this.baseMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.baseMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.baseMap.containsValue(value);
    }

    public V get(Object key) {
        return this.baseMap.get(key);
    }

    public synchronized V put(K key, V value) {
        this.clearList();
        return this.baseMap.put(key, value);
    }

    public synchronized V remove(Object key) {
        this.clearList();
        return this.baseMap.remove(key);
    }

    public synchronized void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.clearList();
        this.baseMap.putAll(m);
    }

    public synchronized void clear() {
        this.clearList();
        this.baseMap.clear();
    }

    @NotNull
    public Set<K> keySet() {
        return this.baseMap.keySet();
    }

    @NotNull
    public synchronized Collection<V> values() {
        return Collections.unmodifiableList(this.getValuesList().stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @NotNull
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        return new LinkedHashSet<Map.Entry<K, V>>(this.getValuesList());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SortedIndexableMapWrapper)) {
            return false;
        }
        return this.comparator.equals(((SortedIndexableMapWrapper)o).comparator) && this.baseMap.equals(((SortedIndexableMapWrapper)o).baseMap);
    }

    public int hashCode() {
        return this.baseMap.hashCode();
    }

    public V getOrDefault(Object key, V defaultValue) {
        return this.baseMap.getOrDefault(key, defaultValue);
    }

    public synchronized void forEach(BiConsumer<? super K, ? super V> action) {
        this.getValuesList().forEach((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    public synchronized void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.clearList();
        this.baseMap.replaceAll(function);
    }

    public synchronized V putIfAbsent(K key, V value) {
        this.clearList();
        return this.baseMap.putIfAbsent(key, value);
    }

    public synchronized boolean remove(Object key, Object value) {
        this.clearList();
        return this.baseMap.remove(key, value);
    }

    public synchronized boolean replace(K key, V oldValue, V newValue) {
        this.clearList();
        return this.baseMap.replace(key, oldValue, newValue);
    }

    public synchronized V replace(K key, V value) {
        this.clearList();
        return this.baseMap.replace(key, value);
    }

    public synchronized V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.clearList();
        return this.baseMap.computeIfAbsent((K)key, mappingFunction);
    }

    public synchronized V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.clearList();
        return this.baseMap.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    public synchronized V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.clearList();
        return this.baseMap.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    public synchronized V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.clearList();
        return this.baseMap.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    public synchronized V getByIndex(int index) {
        return this.getValuesList().get(index).getValue();
    }
}

