/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import io.deephaven.base.reference.SimpleReference;
import io.deephaven.base.reference.WeakReferenceWrapper;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubscriptionSet<LISTENER_TYPE> {
    private Entry[] subscriptions;
    private int size;

    public SubscriptionSet() {
        this.clear();
    }

    public final void clear() {
        this.subscriptions = (Entry[])Array.newInstance(Entry.class, 1);
        this.size = 0;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean collect() {
        int initialSize = this.size;
        int si = 0;
        while (si < this.size) {
            if (this.subscriptions[si].getListener() == null) {
                this.removeAt(si);
                continue;
            }
            ++si;
        }
        return initialSize > 0 && this.size == 0;
    }

    public final Entry makeEntryFor(LISTENER_TYPE listener) {
        return new Entry(listener);
    }

    public final boolean add(@NotNull LISTENER_TYPE listener, @NotNull Entry entry) {
        Require.eq(listener, (String)"listener", entry.getListener(), (String)"entry.getListener()");
        int initialSize = this.size;
        boolean found = false;
        int si = 0;
        while (si < this.size) {
            Entry currentEntry = this.subscriptions[si];
            Object currentListener = currentEntry.getListener();
            if (currentListener == null) {
                this.removeAt(si);
                continue;
            }
            if (currentEntry == entry || currentListener == listener) {
                found = true;
            }
            ++si;
        }
        if (found) {
            return false;
        }
        if (this.size == this.subscriptions.length) {
            this.subscriptions = Arrays.copyOf(this.subscriptions, this.size << 1);
        }
        this.subscriptions[this.size++] = entry;
        return initialSize == 0;
    }

    public final boolean remove(LISTENER_TYPE listener) {
        int initialSize = this.size;
        int si = 0;
        while (si < this.size) {
            Object currentListener = this.subscriptions[si].getListener();
            if (currentListener == null || currentListener == listener) {
                this.removeAt(si);
                continue;
            }
            ++si;
        }
        return initialSize > 0 && this.size == 0;
    }

    public final boolean deliverNotification(@NotNull Consumer<LISTENER_TYPE> procedure, boolean activeOnly) {
        int initialSize = this.size;
        int si = 0;
        while (si < this.size) {
            Entry currentEntry = this.subscriptions[si];
            Object currentListener = currentEntry.getListener();
            if (currentListener == null) {
                this.removeAt(si);
                continue;
            }
            if (!activeOnly || currentEntry.isActive()) {
                procedure.accept(currentListener);
            }
            ++si;
        }
        return initialSize > 0 && this.size == 0;
    }

    public final <NOTIFICATION_TYPE> boolean deliverNotification(@NotNull BiConsumer<LISTENER_TYPE, NOTIFICATION_TYPE> procedure, @Nullable NOTIFICATION_TYPE notification, boolean activeOnly) {
        int initialSize = this.size;
        int si = 0;
        while (si < this.size) {
            Entry currentEntry = this.subscriptions[si];
            Object currentListener = currentEntry.getListener();
            if (currentListener == null) {
                this.removeAt(si);
                continue;
            }
            if (!activeOnly || currentEntry.isActive()) {
                procedure.accept(currentListener, notification);
            }
            ++si;
        }
        return initialSize > 0 && this.size == 0;
    }

    private void removeAt(int subscriptionIndex) {
        int lastSubscriptionIndex = --this.size;
        this.subscriptions[subscriptionIndex] = this.subscriptions[lastSubscriptionIndex];
        this.subscriptions[lastSubscriptionIndex] = null;
    }

    public class Entry {
        private final SimpleReference<LISTENER_TYPE> listenerReference;
        private boolean active;

        private Entry(LISTENER_TYPE listener) {
            this.listenerReference = WeakReferenceWrapper.maybeCreateWeakReference((Object)Require.neqNull(listener, (String)"listener"));
        }

        private LISTENER_TYPE getListener() {
            return this.listenerReference.get();
        }

        private boolean isActive() {
            return this.active;
        }

        public void activate() {
            Assert.holdsLock((Object)SubscriptionSet.this, (String)"SubscriptionSet.this");
            this.active = true;
        }
    }
}

