/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.cache;

import io.deephaven.base.verify.Require;
import io.deephaven.hash.KeyedObjectHashMap;
import io.deephaven.hash.KeyedObjectKey;
import io.deephaven.util.datastructures.cache.OffsetLookup;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReverseOffsetLookupCache<VALUE_TYPE, EXTRA_INPUT_TYPE>
implements ToIntFunction<VALUE_TYPE> {
    private static final int NULL_INDEX = -1;
    private final OffsetLookup<VALUE_TYPE, EXTRA_INPUT_TYPE> lookupFunction;
    private final Map<VALUE_TYPE, CachedMapping<VALUE_TYPE>> reverseLookup = new KeyedObjectHashMap(ReverseOffsetLookupCache.getKeyDefinition());
    private volatile int highestKeyChecked = -1;

    public ReverseOffsetLookupCache(@NotNull OffsetLookup<VALUE_TYPE, EXTRA_INPUT_TYPE> lookupFunction) {
        this.lookupFunction = (OffsetLookup)Require.neqNull(lookupFunction, (String)"lookupFunction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensurePopulated(int highestIndexNeeded, @NotNull Supplier<EXTRA_INPUT_TYPE> extraFactory, @Nullable Consumer<EXTRA_INPUT_TYPE> extraCleanup) {
        if (highestIndexNeeded > this.highestKeyChecked) {
            Map<VALUE_TYPE, CachedMapping<VALUE_TYPE>> map = this.reverseLookup;
            synchronized (map) {
                if (highestIndexNeeded > this.highestKeyChecked) {
                    EXTRA_INPUT_TYPE extra = extraFactory.get();
                    try {
                        for (int key = this.highestKeyChecked + 1; key <= highestIndexNeeded; ++key) {
                            VALUE_TYPE value = this.lookupFunction.lookup(key, extra);
                            if (value == null) continue;
                            this.reverseLookup.put(value, new CachedMapping<VALUE_TYPE>(value, key));
                        }
                        this.highestKeyChecked = highestIndexNeeded;
                    }
                    finally {
                        if (extraCleanup != null) {
                            extraCleanup.accept(extra);
                        }
                    }
                }
            }
        }
    }

    @Override
    public int applyAsInt(VALUE_TYPE value) {
        CachedMapping<VALUE_TYPE> mapping = this.reverseLookup.get(value);
        return mapping == null ? -1 : mapping.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<VALUE_TYPE, CachedMapping<VALUE_TYPE>> map = this.reverseLookup;
        synchronized (map) {
            this.highestKeyChecked = -1;
            this.reverseLookup.clear();
        }
    }

    private static <VALUE_TYPE> KeyedObjectKey.Basic<VALUE_TYPE, CachedMapping<VALUE_TYPE>> getKeyDefinition() {
        return CachedMappingKeyDef.INSTANCE;
    }

    private static class CachedMappingKeyDef<VALUE_TYPE>
    extends KeyedObjectKey.Basic<VALUE_TYPE, CachedMapping<VALUE_TYPE>> {
        private static final KeyedObjectKey.Basic INSTANCE = new CachedMappingKeyDef();

        private CachedMappingKeyDef() {
        }

        public final VALUE_TYPE getKey(CachedMapping<VALUE_TYPE> pair) {
            return pair.value;
        }
    }

    private static class CachedMapping<VALUE_TYPE> {
        private final VALUE_TYPE value;
        private final int index;

        private CachedMapping(VALUE_TYPE value, int index) {
            this.value = value;
            this.index = index;
        }
    }
}

