/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.cache;

import io.deephaven.base.MathUtil;
import io.deephaven.base.verify.Require;
import io.deephaven.util.datastructures.cache.BaseOffsetLookupCache;
import io.deephaven.util.datastructures.cache.OffsetLookup;
import io.deephaven.util.datastructures.cache.OffsetLookupCache;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import org.jetbrains.annotations.NotNull;

public class SoftArrayBackedOffsetLookupCache<VALUE_TYPE, EXTRA_INPUT_TYPE>
extends BaseOffsetLookupCache<VALUE_TYPE, EXTRA_INPUT_TYPE> {
    private static final int LOG2_BLOCK_SIZE = 12;
    private static final int BLOCK_SIZE = 4096;
    private static final SoftReference[] ZERO_LENGTH_SOFT_REFERENCE_ARRAY = new SoftReference[0];
    private volatile SoftReference<VALUE_TYPE[]>[] cachedValues = ZERO_LENGTH_SOFT_REFERENCE_ARRAY;

    private static int INDEX_TO_BLOCK_INDEX(int index) {
        return index >> 12;
    }

    private static int INDEX_TO_SUB_BLOCK_INDEX(int index) {
        return index & 0xFFF;
    }

    public SoftArrayBackedOffsetLookupCache(@NotNull Class<VALUE_TYPE> valueType, @NotNull OffsetLookup<VALUE_TYPE, EXTRA_INPUT_TYPE> lookupFunction) {
        this(valueType, lookupFunction, OffsetLookupCache.createPlaceholder(valueType));
    }

    private SoftArrayBackedOffsetLookupCache(@NotNull Class<VALUE_TYPE> valueType, @NotNull OffsetLookup<VALUE_TYPE, EXTRA_INPUT_TYPE> lookupFunction, @NotNull VALUE_TYPE nullValue) {
        super(lookupFunction, nullValue, valueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VALUE_TYPE get(int index, EXTRA_INPUT_TYPE extra) {
        VALUE_TYPE value;
        Object[] block;
        SoftReference<VALUE_TYPE[]> blockRef;
        Require.geqZero((int)index, (String)"index");
        int blockIndex = SoftArrayBackedOffsetLookupCache.INDEX_TO_BLOCK_INDEX(index);
        int subBlockIndex = SoftArrayBackedOffsetLookupCache.INDEX_TO_SUB_BLOCK_INDEX(index);
        SoftReference<VALUE_TYPE[]>[] localCachedValues = this.cachedValues;
        if (this.cachedValues.length <= blockIndex || (blockRef = localCachedValues[blockIndex]) == null || (block = blockRef.get()) == null || (value = block[subBlockIndex]) == null) {
            SoftArrayBackedOffsetLookupCache softArrayBackedOffsetLookupCache = this;
            synchronized (softArrayBackedOffsetLookupCache) {
                localCachedValues = this.cachedValues;
                if (this.cachedValues.length <= blockIndex) {
                    SoftReference[] newCachedValues = new SoftReference[1 << MathUtil.ceilLog2((int)(blockIndex + 1))];
                    System.arraycopy(localCachedValues, 0, newCachedValues, 0, localCachedValues.length);
                    localCachedValues = newCachedValues;
                    this.cachedValues = newCachedValues;
                }
                if ((blockRef = localCachedValues[blockIndex]) == null || (block = blockRef.get()) == null) {
                    block = (Object[])Array.newInstance(this.valueType, 4096);
                    localCachedValues[blockIndex] = blockRef = new SoftReference<VALUE_TYPE[]>(block);
                }
                if ((value = block[subBlockIndex]) == null) {
                    value = this.lookupFunction.lookup(index, extra);
                    block[subBlockIndex] = value == null ? this.nullValue : value;
                    return value;
                }
            }
        }
        return value == this.nullValue ? null : (VALUE_TYPE)value;
    }

    @Override
    public synchronized void clear() {
        this.cachedValues = ZERO_LENGTH_SOFT_REFERENCE_ARRAY;
    }
}

