/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.hash;

import io.deephaven.base.verify.Assert;
import io.deephaven.hash.IntrusiveChainedHashAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntrusiveChainedEntryPool<VALUE_TYPE> {
    private final IntrusiveChainedHashAdapter<VALUE_TYPE> adapter;
    private VALUE_TYPE top;

    public IntrusiveChainedEntryPool(@NotNull IntrusiveChainedHashAdapter<VALUE_TYPE> adapter) {
        this.adapter = adapter;
    }

    public void give(@NotNull VALUE_TYPE entry) {
        Assert.eqNull((Object)this.adapter.getNext(entry), (String)"adapter.getNext(entry)");
        if (this.top != null) {
            this.adapter.setNext(entry, this.top);
        }
        this.top = entry;
    }

    @Nullable
    public VALUE_TYPE take() {
        if (this.top == null) {
            return null;
        }
        VALUE_TYPE result = this.top;
        this.top = this.adapter.getNext(this.top);
        this.adapter.setNext(result, null);
        return result;
    }
}

