/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.intrusive;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IntrusiveArraySet<T>
implements Set<T> {
    private final Adapter<T> adapter;
    private int size = 0;
    private T[] storage;

    public IntrusiveArraySet(Adapter<T> adapter, Class<T> elementClass) {
        this(adapter, elementClass, 16);
    }

    public IntrusiveArraySet(Adapter<T> adapter, Class<T> elementClass, int initialCapacity) {
        this.adapter = adapter;
        this.storage = (Object[])Array.newInstance(elementClass, initialCapacity);
    }

    public void ensureCapacity(int capacity) {
        if (this.storage.length >= capacity) {
            return;
        }
        this.storage = Arrays.copyOf(this.storage, capacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        int candidateSlot = this.adapter.getSlot(o);
        return candidateSlot >= 0 && candidateSlot < this.size && this.storage[candidateSlot] == o;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new IteratorImpl();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return Arrays.copyOf(this.storage, this.size);
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] a) {
        T1[] r;
        Object[] objectArray = r = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        if (this.size >= 0) {
            System.arraycopy(this.storage, 0, r, 0, this.size);
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return r;
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        int slot = this.adapter.getSlot(t);
        if (slot >= 0 && slot < this.size && this.storage[slot] == t) {
            return false;
        }
        if (this.size == this.storage.length) {
            this.ensureCapacity(this.storage.length * 2);
        }
        this.storage[this.size] = t;
        this.adapter.setSlot(t, this.size++);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        int candidateSlot = this.adapter.getSlot(o);
        if (candidateSlot >= 0 && candidateSlot < this.size && this.storage[candidateSlot] == o) {
            if (candidateSlot < this.size - 1) {
                this.storage[candidateSlot] = this.storage[this.size - 1];
                this.adapter.setSlot(this.storage[candidateSlot], candidateSlot);
            }
            --this.size;
            this.storage[this.size] = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object c : collection) {
            if (this.contains(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        boolean added = false;
        for (T t : c) {
            added = this.add(t) || added;
        }
        return added;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        int destinationSlot = 0;
        for (Object c : collection) {
            int slot = this.adapter.getSlot(c);
            if (slot < 0 || slot >= this.size || this.storage[slot] != c || destinationSlot > slot) continue;
            if (destinationSlot == slot) {
                ++destinationSlot;
                continue;
            }
            this.storage[slot] = this.storage[destinationSlot];
            this.storage[destinationSlot] = c;
            this.adapter.setSlot(this.storage[destinationSlot], destinationSlot);
            this.adapter.setSlot(this.storage[slot], slot);
            ++destinationSlot;
        }
        int oldSize = this.size;
        this.size = destinationSlot;
        Arrays.fill(this.storage, this.size, oldSize, null);
        return oldSize != this.size;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        boolean removed = false;
        for (Object c : collection) {
            removed = this.remove(c) || removed;
        }
        return removed;
    }

    @Override
    public void clear() {
        Arrays.fill(this.storage, 0, this.size, null);
        this.size = 0;
    }

    public void sort(@NotNull Comparator<? super T> c) {
        int s = this.size;
        Arrays.sort(this.storage, 0, s, c);
        for (int ii = 0; ii < s; ++ii) {
            this.adapter.setSlot(this.storage[ii], ii);
        }
    }

    private class IteratorImpl
    implements Iterator<T> {
        int index = 0;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.index < IntrusiveArraySet.this.size;
        }

        @Override
        public T next() {
            return IntrusiveArraySet.this.storage[this.index++];
        }

        @Override
        public void remove() {
            if (this.index == 0 || this.index > IntrusiveArraySet.this.size) {
                throw new IllegalStateException();
            }
            if (this.index < IntrusiveArraySet.this.size) {
                IntrusiveArraySet.this.storage[this.index - 1] = IntrusiveArraySet.this.storage[IntrusiveArraySet.this.size - 1];
                IntrusiveArraySet.this.adapter.setSlot(IntrusiveArraySet.this.storage[this.index - 1], this.index - 1);
                --this.index;
                IntrusiveArraySet.this.storage[IntrusiveArraySet.this.size - 1] = null;
            }
            --IntrusiveArraySet.this.size;
        }
    }

    public static interface Adapter<T> {
        public int getSlot(T var1);

        public void setSlot(T var1, int var2);
    }
}

