/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.linked;

import org.jetbrains.annotations.NotNull;

public abstract class IntrusiveDoublyLinkedStructureBase<VALUE_TYPE> {
    @NotNull
    private final Adapter<VALUE_TYPE> adapter;

    protected IntrusiveDoublyLinkedStructureBase(@NotNull Adapter<VALUE_TYPE> adapter) {
        this.adapter = adapter;
    }

    @NotNull
    protected final VALUE_TYPE getNext(@NotNull VALUE_TYPE node) {
        return this.adapter.getNext(node);
    }

    protected final void setNext(@NotNull VALUE_TYPE node, @NotNull VALUE_TYPE other) {
        this.adapter.setNext(node, other);
    }

    @NotNull
    protected final VALUE_TYPE getPrev(@NotNull VALUE_TYPE node) {
        return this.adapter.getPrev(node);
    }

    protected final void setPrev(@NotNull VALUE_TYPE node, @NotNull VALUE_TYPE other) {
        this.adapter.setPrev(node, other);
    }

    protected final boolean isLinked(@NotNull VALUE_TYPE node) {
        return this.adapter.getNext(node) != node;
    }

    @NotNull
    protected final VALUE_TYPE linkBefore(@NotNull VALUE_TYPE node, @NotNull VALUE_TYPE other) {
        this.setNext(node, other);
        this.setPrev(node, this.getPrev(other));
        this.setNext(this.getPrev(other), node);
        this.setPrev(other, node);
        return node;
    }

    @NotNull
    protected final VALUE_TYPE linkAfter(@NotNull VALUE_TYPE node, @NotNull VALUE_TYPE other) {
        this.setPrev(node, other);
        this.setNext(node, this.getNext(other));
        this.setPrev(this.getNext(other), node);
        this.setNext(other, node);
        return node;
    }

    @NotNull
    protected final VALUE_TYPE unlink(@NotNull VALUE_TYPE node) {
        this.setNext(this.getPrev(node), this.getNext(node));
        this.setPrev(this.getNext(node), this.getPrev(node));
        this.setNext(node, node);
        this.setPrev(node, node);
        return node;
    }

    protected final boolean compatible(@NotNull IntrusiveDoublyLinkedStructureBase<VALUE_TYPE> other) {
        return this.getClass() == other.getClass() && this.adapter == other.adapter;
    }

    public static interface Adapter<NODE_TYPE> {
        @NotNull
        public NODE_TYPE getNext(@NotNull NODE_TYPE var1);

        public void setNext(@NotNull NODE_TYPE var1, @NotNull NODE_TYPE var2);

        @NotNull
        public NODE_TYPE getPrev(@NotNull NODE_TYPE var1);

        public void setPrev(@NotNull NODE_TYPE var1, @NotNull NODE_TYPE var2);
    }
}

