/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.linked;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntrusiveSinglyLinkedQueue<VALUE_TYPE> {
    VALUE_TYPE head = null;
    VALUE_TYPE tail = null;
    private long count = 0L;
    @NotNull
    private final Adapter<VALUE_TYPE> adapter;

    public boolean offer(@NotNull VALUE_TYPE item) {
        this.setNext(item, null);
        if (this.isEmpty()) {
            this.tail = item;
            this.head = this.tail;
        } else {
            this.setNext(this.tail, item);
            this.tail = item;
        }
        ++this.count;
        return true;
    }

    public VALUE_TYPE poll() {
        if (this.isEmpty()) {
            return null;
        }
        VALUE_TYPE retval = this.head;
        this.head = this.getNext(this.head);
        if (this.tail == retval) {
            this.tail = this.head;
        }
        --this.count;
        return retval;
    }

    public VALUE_TYPE peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.head;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public long size() {
        return this.count;
    }

    public IntrusiveSinglyLinkedQueue(@NotNull Adapter<VALUE_TYPE> adapter) {
        this.adapter = adapter;
    }

    @Nullable
    private VALUE_TYPE getNext(@NotNull VALUE_TYPE node) {
        return this.adapter.getNext(node);
    }

    private void setNext(@NotNull VALUE_TYPE node, @Nullable VALUE_TYPE other) {
        this.adapter.setNext(node, other);
    }

    public static interface Adapter<NODE_TYPE> {
        @Nullable
        public NODE_TYPE getNext(@NotNull NODE_TYPE var1);

        public void setNext(@NotNull NODE_TYPE var1, @Nullable NODE_TYPE var2);
    }
}

