/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.locks;

import io.deephaven.util.SafeCloseable;
import io.deephaven.util.function.ThrowingBooleanSupplier;
import io.deephaven.util.function.ThrowingRunnable;
import io.deephaven.util.function.ThrowingSupplier;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;

public interface FunctionalLock
extends Lock {
    default public <EXCEPTION_TYPE extends Exception> void doLocked(@NotNull ThrowingRunnable<EXCEPTION_TYPE> runnable) throws EXCEPTION_TYPE {
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    default public <EXCEPTION_TYPE extends Exception> void doLockedInterruptibly(@NotNull ThrowingRunnable<EXCEPTION_TYPE> runnable) throws InterruptedException, EXCEPTION_TYPE {
        this.lockInterruptibly();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    default public <RESULT_TYPE, EXCEPTION_TYPE extends Exception> RESULT_TYPE computeLocked(@NotNull ThrowingSupplier<RESULT_TYPE, EXCEPTION_TYPE> supplier) throws EXCEPTION_TYPE {
        this.lock();
        try {
            RESULT_TYPE RESULT_TYPE = supplier.get();
            return RESULT_TYPE;
        }
        finally {
            this.unlock();
        }
    }

    default public <EXCEPTION_TYPE extends Exception> boolean testLocked(@NotNull ThrowingBooleanSupplier<EXCEPTION_TYPE> supplier) throws EXCEPTION_TYPE {
        this.lock();
        try {
            boolean bl = supplier.getAsBoolean();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    default public <RESULT_TYPE, EXCEPTION_TYPE extends Exception> RESULT_TYPE computeLockedInterruptibly(@NotNull ThrowingSupplier<RESULT_TYPE, EXCEPTION_TYPE> supplier) throws InterruptedException, EXCEPTION_TYPE {
        this.lockInterruptibly();
        try {
            RESULT_TYPE RESULT_TYPE = supplier.get();
            return RESULT_TYPE;
        }
        finally {
            this.unlock();
        }
    }

    default public SafeCloseable lockCloseable() {
        SafeCloseable unlock = this::unlock;
        this.lock();
        return unlock;
    }

    default public SafeCloseable lockInterruptiblyCloseable() throws InterruptedException {
        SafeCloseable unlock = this::unlock;
        this.lockInterruptibly();
        return unlock;
    }
}

