/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.metrics;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;

public class MetricsManager {
    private static final Logger log = LoggerFactory.getLogger(MetricsManager.class);
    public static final boolean enabled = Configuration.getInstance().getBooleanForClassWithDefault(MetricsManager.class, "enabled", false);
    private static final boolean toStdout = Configuration.getInstance().getBooleanForClassWithDefault(MetricsManager.class, "toStdout", false);
    private static final long logPeriodNanos = 1000000000L * (long)Configuration.getInstance().getIntegerForClassWithDefault(MetricsManager.class, "logPeriodSeconds", 120);
    private static final boolean periodicUpdates = Configuration.getInstance().getBooleanForClassWithDefault(MetricsManager.class, "periodicUpdates", false);
    private static final int maxMetricsPerType = Configuration.getInstance().getIntegerForClassWithDefault(MetricsManager.class, "maxMetricsPerType", 256);
    public static final MetricsManager instance = new MetricsManager();
    private static final Consumer<String> logger = s -> {
        if (toStdout) {
            System.out.println((String)s);
        } else {
            log.info(s);
        }
    };
    private final MetricsFamily<int[]> intCounterMetrics = new MetricsCounterFamily<int[]>(){

        @Override
        protected int[] makeMetricsArray() {
            return new int[maxMetricsPerType];
        }

        @Override
        protected long get(int[] counters, int i) {
            return counters[i];
        }

        @Override
        protected String familyName() {
            return "IntCounter";
        }

        @Override
        protected void clear(int[] counters, int size) {
            for (int i = 0; i < size; ++i) {
                counters[i] = 0;
            }
        }

        @Override
        protected void accumulateSnapshot(int[] src, int[] dst, int size) {
            for (int i = 0; i < size; ++i) {
                int n = i;
                dst[n] = dst[n] + src[i];
            }
        }
    };
    private final MetricsFamily<long[]> longCounterMetrics = new MetricsCounterFamily<long[]>(){

        @Override
        protected long[] makeMetricsArray() {
            return new long[maxMetricsPerType];
        }

        @Override
        protected long get(long[] counters, int i) {
            return counters[i];
        }

        @Override
        protected String familyName() {
            return "LongCounter";
        }

        @Override
        protected void clear(long[] counters, int size) {
            for (int i = 0; i < size; ++i) {
                counters[i] = 0L;
            }
        }

        @Override
        protected void accumulateSnapshot(long[] src, long[] dst, int size) {
            for (int i = 0; i < size; ++i) {
                int n = i;
                dst[n] = dst[n] + src[i];
            }
        }
    };
    private final MetricsFamily<int[][]> longCounterLog2HistogramMetrics = new MetricsFamily<int[][]>(){

        @Override
        protected int[][] makeMetricsArray() {
            return new int[maxMetricsPerType][65];
        }

        @Override
        protected String familyName() {
            return "LongCounterLog2Histogram";
        }

        @Override
        protected void clear(int[][] counters, int size) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < 65; ++j) {
                    counters[i][j] = 0;
                }
            }
        }

        @Override
        protected void accumulateSnapshot(int[][] src, int[][] dst, int size) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < 65; ++j) {
                    int[] nArray = dst[i];
                    int n = j;
                    nArray[n] = nArray[n] + src[i][j];
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void log(String updateTag, Consumer<String> logger) {
            TObjectIntHashMap nameToMetricIdCopy;
            String prefix = "Metrics " + this.familyName() + " " + updateTag + ": ";
            if (this.snapshotCount == 0) {
                String s = prefix + "No counters defined.";
                logger.accept(s);
                return;
            }
            3 var5_6 = this;
            synchronized (var5_6) {
                nameToMetricIdCopy = new TObjectIntHashMap(this.nameToMetricId);
            }
            for (int i = 0; i < this.snapshotCount; ++i) {
                long nsamples = 0L;
                StringBuilder sb = new StringBuilder(prefix);
                String name = this.namesSortedSnapshot[i];
                String key = "|key: i:n => 2^i <= x < 2^(i+1), z:n => x = 0.| ";
                sb.append("|key: i:n => 2^i <= x < 2^(i+1), z:n => x = 0.| ").append(name).append("={ ");
                int metricId = nameToMetricIdCopy.get((Object)name);
                boolean haveBefore = false;
                for (int j = 64; j >= 0; --j) {
                    int v = ((int[][])this.countersSnapshot)[metricId][j];
                    if (v == 0) continue;
                    if (haveBefore) {
                        sb.append(", ");
                    }
                    if (j == 64) {
                        sb.append("z");
                    } else {
                        int msb = 63 - j;
                        sb.append(msb);
                    }
                    sb.append(":").append(v);
                    haveBefore = true;
                    nsamples += (long)v;
                }
                sb.append(" }, nsamples=").append(nsamples);
                logger.accept(sb.toString());
            }
        }
    };
    private final TimerThread timerThread = new TimerThread();

    private MetricsManager() {
    }

    int registerIntCounterMetric(String name) {
        if (!enabled) {
            return 0;
        }
        this.timerThread.ensureStarted();
        return this.intCounterMetrics.registerMetric(name);
    }

    int registerLongCounterMetric(String name) {
        if (!enabled) {
            return 0;
        }
        this.timerThread.ensureStarted();
        return this.longCounterMetrics.registerMetric(name);
    }

    int registerLongCounterLog2HistogramMetric(String name) {
        if (!enabled) {
            return 0;
        }
        this.timerThread.ensureStarted();
        return this.longCounterLog2HistogramMetrics.registerMetric(name);
    }

    void sampleIntCounter(int id, long n) {
        if (!enabled) {
            return;
        }
        int[] threadMetrics = (int[])this.intCounterMetrics.counters.get();
        int n2 = id;
        threadMetrics[n2] = (int)((long)threadMetrics[n2] + n);
    }

    void sampleLongCounter(int id, long n) {
        if (!enabled) {
            return;
        }
        long[] threadMetrics = (long[])this.longCounterMetrics.counters.get();
        int n2 = id;
        threadMetrics[n2] = threadMetrics[n2] + n;
    }

    void sampleLongCounterLog2HistogramCount(int id, long v) {
        if (!enabled) {
            return;
        }
        int[][] threadMetrics = (int[][])this.longCounterLog2HistogramMetrics.counters.get();
        int[] nArray = threadMetrics[id];
        int n = Long.numberOfLeadingZeros(v);
        nArray[n] = nArray[n] + 1;
    }

    public void update(String updateTag) {
        this.update(updateTag, logger);
    }

    public void update(String updateTag, Consumer<String> logger) {
        this.intCounterMetrics.snapshotCounters();
        this.longCounterMetrics.snapshotCounters();
        this.longCounterLog2HistogramMetrics.snapshotCounters();
        this.intCounterMetrics.log(updateTag, logger);
        this.longCounterMetrics.log(updateTag, logger);
        this.longCounterLog2HistogramMetrics.log(updateTag, logger);
    }

    public void bluntResetAllCounters() {
        this.intCounterMetrics.bluntResetCounters();
        this.longCounterMetrics.bluntResetCounters();
        this.longCounterLog2HistogramMetrics.bluntResetCounters();
    }

    public void stopPeriodicUpdates() {
        logger.accept(MetricsManager.class.getSimpleName() + ": Period updates stopped.");
        this.timerThread.shutdown();
    }

    public void noPeriodicUpdates() {
        this.stopPeriodicUpdates();
    }

    public static void resetCounters() {
        instance.bluntResetAllCounters();
    }

    public static void updateCounters() {
        MetricsManager.updateCounters("");
    }

    public static String getCounters() {
        return MetricsManager.getCounters("");
    }

    private static void updateCounters(String m) {
        instance.update(m);
    }

    private static String getCounters(String m) {
        StringBuilder sb = new StringBuilder();
        instance.update(m, s -> sb.append((String)s).append('\n'));
        return sb.toString();
    }

    private static class TimerThread
    extends Thread {
        private boolean running = false;
        private volatile boolean shutdownRequested = false;

        public TimerThread() {
            this.setDaemon(true);
        }

        public boolean shouldBeRunning() {
            return enabled && periodicUpdates && !this.shutdownRequested;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ensureStarted() {
            if (!this.shouldBeRunning()) {
                return;
            }
            TimerThread timerThread = this;
            synchronized (timerThread) {
                if (!this.shouldBeRunning()) {
                    return;
                }
                this.start();
                this.running = true;
            }
        }

        @Override
        public void run() {
            long nowNanos;
            logger.accept(MetricsManager.class.getSimpleName() + ": Starting periodic updates.");
            String updateStr = "periodic";
            instance.update("periodic");
            long lastPeriodNanosTs = nowNanos = System.nanoTime();
            long nextUpdateNanos = lastPeriodNanosTs + logPeriodNanos;
            while (!this.shutdownRequested) {
                if (nowNanos < nextUpdateNanos) {
                    long sleepMillis = (nextUpdateNanos - nowNanos) / 1000000L;
                    try {
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    nowNanos = System.nanoTime();
                    continue;
                }
                instance.update("periodic");
                lastPeriodNanosTs = nowNanos = System.nanoTime();
                nextUpdateNanos = lastPeriodNanosTs + logPeriodNanos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            if (!enabled || !periodicUpdates) {
                return;
            }
            TimerThread timerThread = this;
            synchronized (timerThread) {
                if (this.shutdownRequested) {
                    return;
                }
                this.shutdownRequested = true;
                if (!this.running) {
                    return;
                }
            }
            try {
                this.interrupt();
                this.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.running = false;
            }
        }
    }

    private static abstract class MetricsCounterFamily<ArrayType>
    extends MetricsFamily<ArrayType> {
        private MetricsCounterFamily() {
        }

        protected abstract long get(ArrayType var1, int var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void log(String updateTag, Consumer<String> logger) {
            TObjectIntHashMap nameToMetricIdCopy;
            String prefix = "Metrics " + this.familyName() + " " + updateTag + " update: ";
            if (this.snapshotCount == 0) {
                logger.accept(prefix + "No counters defined.");
                return;
            }
            StringBuilder sb = new StringBuilder(prefix);
            MetricsCounterFamily metricsCounterFamily = this;
            synchronized (metricsCounterFamily) {
                nameToMetricIdCopy = new TObjectIntHashMap(this.nameToMetricId);
            }
            for (int i = 0; i < this.snapshotCount; ++i) {
                String name = this.namesSortedSnapshot[i];
                int metricId = nameToMetricIdCopy.get((Object)name);
                long v = this.get(this.countersSnapshot, metricId);
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(name).append('=').append(v);
            }
            logger.accept(sb.toString());
        }
    }

    private static abstract class MetricsFamily<ArrayType> {
        protected int count;
        protected final String[] names = new String[maxMetricsPerType];
        protected final TObjectIntMap<String> nameToMetricId = new TObjectIntHashMap(maxMetricsPerType);
        private final ArrayList<ArrayType> pendingPerThreadCounters = new ArrayList(maxMetricsPerType);
        private ThreadLocal<ArrayType> counters = ThreadLocal.withInitial(() -> {
            if (!enabled) {
                return null;
            }
            ArrayType threadMetrics = this.makeMetricsArray();
            ArrayList<ArrayType> arrayList = this.pendingPerThreadCounters;
            synchronized (arrayList) {
                this.pendingPerThreadCounters.add(threadMetrics);
            }
            return threadMetrics;
        });
        protected final ArrayType countersSnapshot = this.makeMetricsArray();
        protected int snapshotCount;
        protected final String[] namesSortedSnapshot = new String[maxMetricsPerType];
        protected final ArrayList<ArrayType> perThreadCounters = new ArrayList();

        private MetricsFamily() {
        }

        protected abstract ArrayType makeMetricsArray();

        protected abstract String familyName();

        protected abstract void clear(ArrayType var1, int var2);

        protected abstract void accumulateSnapshot(ArrayType var1, ArrayType var2, int var3);

        protected abstract void log(String var1, Consumer<String> var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int registerMetric(String name) {
            if (!enabled) {
                return 0;
            }
            MetricsFamily metricsFamily = this;
            synchronized (metricsFamily) {
                if (this.count == maxMetricsPerType) {
                    throw new IllegalStateException("Max number of " + this.familyName() + " metrics (=" + maxMetricsPerType + ") already reached!");
                }
                if (this.nameToMetricId.containsKey((Object)name)) {
                    throw new IllegalArgumentException(this.familyName() + " name=" + name + " already exists!");
                }
                int id = this.count++;
                this.nameToMetricId.put((Object)name, id);
                this.names[id] = name;
                return id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void snapshotCounters() {
            boolean needsToSort = false;
            Iterator<ArrayType> iterator = this;
            synchronized (iterator) {
                if (this.count > this.snapshotCount) {
                    System.arraycopy(this.names, this.snapshotCount, this.namesSortedSnapshot, this.snapshotCount, this.count - this.snapshotCount);
                    this.snapshotCount = this.count;
                    needsToSort = true;
                }
            }
            if (needsToSort) {
                Arrays.sort(this.namesSortedSnapshot, 0, this.snapshotCount);
            }
            this.clear(this.countersSnapshot, this.snapshotCount);
            iterator = this.pendingPerThreadCounters;
            synchronized (iterator) {
                if (!this.pendingPerThreadCounters.isEmpty()) {
                    this.perThreadCounters.addAll(this.pendingPerThreadCounters);
                    this.pendingPerThreadCounters.clear();
                }
            }
            for (ArrayType threadCounters : this.perThreadCounters) {
                this.accumulateSnapshot(threadCounters, this.countersSnapshot, this.snapshotCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void bluntResetCounters() {
            int size;
            Object object = this;
            synchronized (object) {
                size = this.count;
            }
            object = this.pendingPerThreadCounters;
            synchronized (object) {
                for (ArrayType threadCounters : this.perThreadCounters) {
                    this.clear(threadCounters, size);
                }
                for (ArrayType pendingCounters : this.pendingPerThreadCounters) {
                    this.clear(pendingCounters, size);
                }
            }
        }
    }
}

