/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.pool;

import io.deephaven.base.LockFreeArrayQueue;
import io.deephaven.base.MathUtil;
import io.deephaven.base.pool.Pool;
import io.deephaven.base.stats.Counter;
import io.deephaven.base.stats.Stats;
import io.deephaven.base.verify.Require;
import io.deephaven.util.pool.PoolEx;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Supplier;

public class ThreadSafeLenientFixedSizePool<T>
implements Pool.MultiPool<T>,
PoolEx<T> {
    public static final int MIN_SIZE = 7;
    private final LockFreeArrayQueue<T> pool;
    private final Function<ThreadSafeLenientFixedSizePool<T>, T> factory;
    private final Consumer<? super T> clearingProcedure;
    private final Counter extraFactoryCalls;

    private static <T> Function<ThreadSafeLenientFixedSizePool<T>, T> makeFactoryAdapter(Supplier<T> supplier) {
        return arg -> supplier.get();
    }

    public ThreadSafeLenientFixedSizePool(String name, int size, Supplier<T> initFactory, Supplier<T> overflowFactory, Consumer<? super T> clearingProcedure) {
        this(name, Require.geq((int)size, (String)"size", (int)7, (String)"MIN_SIZE"), ThreadSafeLenientFixedSizePool.makeFactoryAdapter((Supplier)Require.neqNull(initFactory, (String)"initFactory")), ThreadSafeLenientFixedSizePool.makeFactoryAdapter((Supplier)Require.neqNull(overflowFactory, (String)"overflowFactory")), clearingProcedure);
    }

    public ThreadSafeLenientFixedSizePool(String name, int size, Function<ThreadSafeLenientFixedSizePool<T>, T> initFactory, Function<ThreadSafeLenientFixedSizePool<T>, T> overflowFactory, Consumer<? super T> clearingProcedure) {
        Require.geq((int)size, (String)"size", (int)7, (String)"MIN_SIZE");
        Require.neqNull(initFactory, (String)"initFactory");
        Require.neqNull(overflowFactory, (String)"overflowFactory");
        this.factory = overflowFactory;
        this.clearingProcedure = clearingProcedure;
        this.pool = new LockFreeArrayQueue(MathUtil.ceilLog2((int)(size + 2)));
        for (int i = 0; i < size; ++i) {
            this.pool.enqueue(initFactory.apply(this));
        }
        this.extraFactoryCalls = name == null ? null : (Counter)Stats.makeItem((String)name, (String)"extraFactoryCalls", (LongFunction)Counter.FACTORY).getValue();
    }

    public T take() {
        Object item = this.pool.dequeue();
        if (item == null) {
            if (this.extraFactoryCalls != null) {
                this.extraFactoryCalls.sample(1L);
            }
            return this.factory.apply(this);
        }
        return (T)item;
    }

    public void give(T item) {
        this.giveInternal(item);
    }

    protected boolean giveInternal(T item) {
        if (null == item) {
            return false;
        }
        if (null != this.clearingProcedure) {
            this.clearingProcedure.accept(item);
        }
        return this.pool.enqueue(item);
    }

    @Deprecated
    public T takeMaybeNull() {
        return this.tryTake();
    }

    @Override
    public T tryTake() {
        return (T)this.pool.dequeue();
    }
}

