/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.process;

import io.deephaven.base.verify.Require;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.process.FatalErrorReporter;
import io.deephaven.util.process.ProcessEnvironment;
import io.deephaven.util.process.ShutdownManager;
import org.jetbrains.annotations.NotNull;

public abstract class BaseProcessEnvironment
implements ProcessEnvironment {
    protected final ShutdownManager shutdownManager;
    protected final FatalErrorReporter fatalErrorReporter;
    protected final String mainClassName;
    protected final Logger log;

    protected BaseProcessEnvironment(@NotNull ShutdownManager shutdownManager, @NotNull FatalErrorReporter fatalErrorReporter, @NotNull String mainClassName, @NotNull Logger log) {
        this.shutdownManager = (ShutdownManager)Require.neqNull((Object)shutdownManager, (String)"shutdownManager");
        this.fatalErrorReporter = (FatalErrorReporter)Require.neqNull((Object)fatalErrorReporter, (String)"fatalErrorReporter");
        this.mainClassName = Require.nonempty((String)mainClassName, (String)"mainClassName");
        this.log = (Logger)Require.neqNull((Object)log, (String)"log");
    }

    @Override
    public final ShutdownManager getShutdownManager() {
        return this.shutdownManager;
    }

    @Override
    public final FatalErrorReporter getFatalErrorReporter() {
        return this.fatalErrorReporter;
    }

    @Override
    public final String getMainClassName() {
        return this.mainClassName;
    }
}

