/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.process;

import io.deephaven.base.system.AsyncSystem;
import io.deephaven.base.system.PrintStreamGlobals;
import io.deephaven.util.process.FatalErrorReporterBase;
import io.deephaven.util.process.ProcessEnvironment;
import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;

public class DefaultFatalErrorReporter
extends FatalErrorReporterBase {
    private static final int EXIT_STATUS = 1;
    private final PrintStream err = PrintStreamGlobals.getErr();

    @Override
    protected void reportImpl(@NotNull String message, @NotNull Throwable throwable, boolean isUncaughtException) {
        boolean initiateShutdown = !ProcessEnvironment.getGlobalShutdownManager().tasksInvoked();
        this.err.println(String.format("%s: %s", initiateShutdown ? "Initiating shutdown due to" : "After shutdown initiated", message));
        throwable.printStackTrace(this.err);
        if (initiateShutdown) {
            AsyncSystem.exit((String)"DefaultFatalErrorReporter", (int)1, (PrintStream)this.err);
        }
        if (isUncaughtException) {
            return;
        }
        this.neverReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void neverReturn() {
        while (true) {
            DefaultFatalErrorReporter defaultFatalErrorReporter = this;
            synchronized (defaultFatalErrorReporter) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

