/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.process;

import io.deephaven.base.verify.Require;
import io.deephaven.util.process.FatalErrorReporter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class FatalErrorReporterBase
implements FatalErrorReporter {
    private final List<FatalErrorReporter.Interceptor> interceptors = new CopyOnWriteArrayList<FatalErrorReporter.Interceptor>();

    protected abstract void reportImpl(@NotNull String var1, @NotNull Throwable var2, boolean var3);

    @Override
    public final void report(@NotNull String message, @NotNull Throwable throwable) {
        this.interceptors.forEach(interceptor -> interceptor.intercept(message, throwable, false));
        this.reportImpl(message, throwable, false);
    }

    @Override
    public final void report(@NotNull String message) {
        this.report(message, new FatalException());
    }

    @Override
    public final void reportAsync(@NotNull String message, @NotNull Throwable throwable) {
        new Thread(() -> this.report(message, throwable), Thread.currentThread().getName() + "-AsyncFatalErrorSignaller").start();
    }

    @Override
    public final void reportAsync(@NotNull String message) {
        this.report(message, new FatalException());
    }

    @Override
    public final void uncaughtException(@NotNull Thread thread, @NotNull Throwable throwable) {
        String message = "Uncaught exception in thread " + thread.getName();
        this.interceptors.forEach(interceptor -> interceptor.intercept(message, throwable, true));
        this.reportImpl(message, throwable, true);
    }

    @Override
    public void addInterceptor(@NotNull FatalErrorReporter.Interceptor interceptor) {
        this.interceptors.add((FatalErrorReporter.Interceptor)Require.neqNull((Object)interceptor, (String)"interceptor"));
    }

    private final class FatalException
    extends RuntimeException {
        private FatalException() {
        }
    }
}

