/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.process;

import io.deephaven.base.verify.Require;
import io.deephaven.configuration.Configuration;
import io.deephaven.configuration.PropertyException;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.process.FatalErrorReporter;
import io.deephaven.util.process.ShutdownManager;
import org.jetbrains.annotations.NotNull;

public interface ProcessEnvironment {
    public ShutdownManager getShutdownManager();

    public FatalErrorReporter getFatalErrorReporter();

    public String getMainClassName();

    public void onStartup();

    public void onShutdown();

    public static ProcessEnvironment get() {
        return (ProcessEnvironment)Require.neqNull((Object)ProcessEnvironment.tryGet(), (String)"GlobalHelper.instance");
    }

    public static ProcessEnvironment tryGet() {
        return GlobalHelper.instance;
    }

    public static ShutdownManager getGlobalShutdownManager() {
        return ProcessEnvironment.get().getShutdownManager();
    }

    public static FatalErrorReporter getGlobalFatalErrorReporter() {
        return ProcessEnvironment.get().getFatalErrorReporter();
    }

    public static String getGlobalMainClassName() {
        return ProcessEnvironment.get().getMainClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessEnvironment set(@NotNull ProcessEnvironment instance, boolean allowReplace) {
        Class<GlobalHelper> clazz = GlobalHelper.class;
        synchronized (GlobalHelper.class) {
            if (!allowReplace && GlobalHelper.instance != null) {
                throw new IllegalStateException("Can not replace ProcessEnvironment " + GlobalHelper.instance + " with " + instance + " unless allowReplace=true");
            }
            GlobalHelper.instance = (ProcessEnvironment)Require.neqNull((Object)instance, (String)"instance");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return GlobalHelper.instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Class<GlobalHelper> clazz = GlobalHelper.class;
        synchronized (GlobalHelper.class) {
            GlobalHelper.instance.getShutdownManager().reset();
            GlobalHelper.instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @NotNull
    public static ProcessEnvironment instantiateFromConfiguration(@NotNull Configuration configuration, @NotNull String mainClassName, @NotNull Logger log) {
        Factory factory;
        String factoryClassName;
        String factoryPropertyNameSuffix = ".processEnvironmentFactory";
        try {
            factoryClassName = configuration.getStringWithDefault(mainClassName + ".processEnvironmentFactory", configuration.getProperty("default.processEnvironmentFactory"));
        }
        catch (PropertyException e) {
            GlobalHelper.reportInstantiationError("Failed to get process environment factory name for " + mainClassName, (Exception)((Object)e), -11);
            return null;
        }
        try {
            factory = (Factory)Class.forName(factoryClassName).newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            GlobalHelper.reportInstantiationError("Failed to instantiate process environment factory " + factoryClassName, e, -12);
            return null;
        }
        try {
            return factory.make(configuration, mainClassName, log);
        }
        catch (Exception e) {
            GlobalHelper.reportInstantiationError("Unable to instantiate process environment for " + mainClassName, e, -13);
            return null;
        }
    }

    @NotNull
    public static ProcessEnvironment basicInteractiveProcessInitialization(@NotNull Configuration configuration, @NotNull String mainClassName, @NotNull Logger log) {
        ProcessEnvironment processEnvironment = ProcessEnvironment.instantiateFromConfiguration(configuration, mainClassName, log);
        ProcessEnvironment.set(processEnvironment, false);
        processEnvironment.onStartup();
        return processEnvironment;
    }

    @NotNull
    public static ProcessEnvironment basicServerInitialization(@NotNull Configuration configuration, @NotNull String mainClassName, @NotNull Logger log) {
        ProcessEnvironment processEnvironment = ProcessEnvironment.basicInteractiveProcessInitialization(configuration, mainClassName, log);
        Thread.currentThread().setName(mainClassName + ".main");
        Thread.setDefaultUncaughtExceptionHandler(processEnvironment.getFatalErrorReporter());
        return processEnvironment;
    }

    public static class GlobalHelper {
        private static volatile ProcessEnvironment instance;

        private static void reportInstantiationError(@NotNull String message, @NotNull Exception exception, int exitStatus) {
            System.err.println(message + ": " + exception);
            exception.printStackTrace(System.err);
            System.exit(exitStatus);
        }
    }

    public static interface Factory {
        public ProcessEnvironment make(@NotNull Configuration var1, @NotNull String var2, @NotNull Logger var3);
    }
}

