/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.process;

import io.deephaven.base.system.PrintStreamGlobals;
import io.deephaven.base.verify.Require;
import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.process.ShutdownManager;
import io.deephaven.util.thread.ThreadDump;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShutdownManagerImpl
implements ShutdownManager {
    private static final Logger log = LoggerFactory.getLogger(ShutdownManagerImpl.class);
    private static final String SHUTDOWN_TIMEOUT_MILLIS_PROP = "ShutdownManager.shutdownTimeoutMillis";
    private final long SHUTDOWN_TIMEOUT_MILLIS = Configuration.getInstance().getLongWithDefault("ShutdownManager.shutdownTimeoutMillis", -1L);
    private final Map<ShutdownManager.OrderingCategory, SynchronizedStack<ShutdownManager.Task>> tasksByOrderingCategory;
    private final AtomicBoolean shutdownTasksInvoked;

    public ShutdownManagerImpl() {
        EnumMap taskStacksByOrderingCategoryTemp = new EnumMap(ShutdownManager.OrderingCategory.class);
        Arrays.stream(ShutdownManager.OrderingCategory.values()).forEach(oc -> taskStacksByOrderingCategoryTemp.put((ShutdownManager.OrderingCategory)((Object)oc), new SynchronizedStack()));
        this.tasksByOrderingCategory = Collections.unmodifiableMap(taskStacksByOrderingCategoryTemp);
        this.shutdownTasksInvoked = new AtomicBoolean(false);
    }

    @Override
    public void addShutdownHookToRuntime() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::maybeInvokeTasks));
    }

    @Override
    public void registerTask(@NotNull ShutdownManager.OrderingCategory orderingCategory, @NotNull ShutdownManager.Task task) {
        this.tasksByOrderingCategory.get(Require.neqNull((Object)((Object)orderingCategory), (String)"orderingCategory")).push(task);
    }

    @Override
    public void deregisterTask(@NotNull ShutdownManager.OrderingCategory orderingCategory, @NotNull ShutdownManager.Task task) {
        this.tasksByOrderingCategory.get(Require.neqNull((Object)((Object)orderingCategory), (String)"orderingCategory")).remove(task);
    }

    @Override
    public void reset() {
        this.tasksByOrderingCategory.values().forEach(SynchronizedStack::clear);
        this.shutdownTasksInvoked.set(false);
    }

    @Override
    public boolean tasksInvoked() {
        return this.shutdownTasksInvoked.get();
    }

    @Override
    public boolean maybeInvokeTasks() {
        if (!this.shutdownTasksInvoked.compareAndSet(false, true)) {
            return false;
        }
        ShutdownManagerImpl.logShutdown(LogLevel.WARN, "Initiating shutdown processing");
        this.installTerminator();
        this.tasksByOrderingCategory.forEach((oc, tasks) -> {
            ShutdownManager.Task task;
            ShutdownManagerImpl.logShutdown(LogLevel.WARN, "Starting to invoke ", oc, " shutdown tasks");
            while ((task = (ShutdownManager.Task)tasks.pop()) != null) {
                try {
                    task.invoke();
                }
                catch (Throwable t) {
                    ShutdownManagerImpl.logShutdown(LogLevel.ERROR, "Shutdown task ", task, " threw ", t);
                }
            }
            ShutdownManagerImpl.logShutdown(LogLevel.WARN, "Done invoking ", oc, " shutdown tasks");
        });
        ShutdownManagerImpl.logShutdown(LogLevel.WARN, "Finished shutdown processing");
        return true;
    }

    public static void logShutdown(LogLevel level, Object ... items) {
        try {
            LogEntry entry = log.getEntry(level);
            for (Object item : items) {
                entry.append((CharSequence)item.toString());
            }
            entry.endl();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureTermination() {
        long start = System.nanoTime();
        long deadline = start + TimeUnit.MILLISECONDS.toNanos(this.SHUTDOWN_TIMEOUT_MILLIS);
        long now = start;
        while (now < deadline) {
            long nanosRemaining = deadline - now;
            long millisRemainingRoundedUp = TimeUnit.NANOSECONDS.toMillis(nanosRemaining + TimeUnit.MILLISECONDS.toNanos(1L) - 1L);
            try {
                Thread.sleep(millisRemainingRoundedUp);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.nanoTime();
        }
        PrintStream destStdErr = PrintStreamGlobals.getErr();
        destStdErr.println("Halting due to shutdown delay greater than " + this.SHUTDOWN_TIMEOUT_MILLIS + "ms. Thread dump:");
        try {
            ThreadDump.threadDump(destStdErr);
            destStdErr.println();
            destStdErr.println("Halted due to shutdown delay greater than " + this.SHUTDOWN_TIMEOUT_MILLIS + "ms");
        }
        catch (Throwable t) {
            destStdErr.println("Failed to generate thread dump: " + t);
        }
        finally {
            destStdErr.flush();
            Runtime.getRuntime().halt(17);
        }
    }

    private void installTerminator() {
        if (this.SHUTDOWN_TIMEOUT_MILLIS >= 0L) {
            Thread terminator = new Thread(this::ensureTermination, "ShutdownTimeoutTerminator");
            terminator.setDaemon(true);
            terminator.start();
        }
    }

    private static class SynchronizedStack<T> {
        private final Deque<T> storage = new ArrayDeque<T>();

        private SynchronizedStack() {
        }

        public synchronized void push(@NotNull T value) {
            this.storage.offerLast(Require.neqNull(value, (String)"value"));
        }

        @Nullable
        public synchronized T pop() {
            return this.storage.pollLast();
        }

        public synchronized void remove(@NotNull T value) {
            this.storage.removeLastOccurrence(Require.neqNull(value, (String)"value"));
        }

        public synchronized void clear() {
            this.storage.clear();
        }
    }
}

