/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.profiling;

import com.sun.management.ThreadMXBean;
import io.deephaven.configuration.Configuration;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.profiling.ThreadMXBeanThreadProfiler;

public final class SunThreadMXBeanThreadProfiler
extends ThreadMXBeanThreadProfiler<ThreadMXBean> {
    @VisibleForTesting
    static final boolean TRY_ENABLE_THREAD_ALLOCATED_MEMORY = Configuration.getInstance().getBooleanForClassWithDefault(SunThreadMXBeanThreadProfiler.class, "tryEnableThreadAllocatedMemory", true);
    private final boolean memoryProfilingAvailable;

    public SunThreadMXBeanThreadProfiler() {
        if (!MEMORY_PROFILING_ENABLED) {
            this.memoryProfilingAvailable = false;
            return;
        }
        if (((ThreadMXBean)this.threadMXBean).isThreadAllocatedMemorySupported() && !((ThreadMXBean)this.threadMXBean).isThreadAllocatedMemoryEnabled() && TRY_ENABLE_THREAD_ALLOCATED_MEMORY) {
            try {
                ((ThreadMXBean)this.threadMXBean).setThreadAllocatedMemoryEnabled(true);
            }
            catch (UnsupportedOperationException e) {
                throw new UnsupportedOperationException("Failed to enable thread allocated memory - set SunThreadMXBeanThreadProfiler.tryEnableThreadAllocatedMemory=false to proceed without it", e);
            }
        }
        this.memoryProfilingAvailable = ((ThreadMXBean)this.threadMXBean).isThreadAllocatedMemorySupported() && ((ThreadMXBean)this.threadMXBean).isThreadAllocatedMemoryEnabled();
    }

    @Override
    public final boolean memoryProfilingAvailable() {
        return this.memoryProfilingAvailable;
    }

    @Override
    public final long getCurrentThreadAllocatedBytes() {
        if (!this.memoryProfilingAvailable) {
            return Long.MIN_VALUE;
        }
        long rawResult = ((ThreadMXBean)this.threadMXBean).getThreadAllocatedBytes(Thread.currentThread().getId());
        return rawResult < 0L ? Long.MIN_VALUE : rawResult;
    }
}

