/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.profiling;

import io.deephaven.configuration.Configuration;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.profiling.ThreadProfiler;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public abstract class ThreadMXBeanThreadProfiler<BEAN_TYPE extends ThreadMXBean>
implements ThreadProfiler {
    @VisibleForTesting
    static final boolean TRY_ENABLE_THREAD_CPU_TIME = Configuration.getInstance().getBooleanForClassWithDefault(ThreadMXBeanThreadProfiler.class, "tryEnableThreadCpuTime", true);
    protected final BEAN_TYPE threadMXBean = ManagementFactory.getThreadMXBean();
    private final boolean cpuProfilingAvailable;

    protected ThreadMXBeanThreadProfiler() {
        if (!CPU_PROFILING_ENABLED) {
            this.cpuProfilingAvailable = false;
            return;
        }
        if (this.threadMXBean.isCurrentThreadCpuTimeSupported() && !this.threadMXBean.isThreadCpuTimeEnabled() && TRY_ENABLE_THREAD_CPU_TIME) {
            try {
                this.threadMXBean.setThreadCpuTimeEnabled(true);
            }
            catch (UnsupportedOperationException e) {
                throw new UnsupportedOperationException("Failed to enable thread cpu time - set ThreadMXBeanThreadProfiler.tryEnableThreadCpuTime=false to proceed without it", e);
            }
        }
        this.cpuProfilingAvailable = this.threadMXBean.isCurrentThreadCpuTimeSupported() && this.threadMXBean.isThreadCpuTimeEnabled();
    }

    @Override
    public final boolean cpuProfilingAvailable() {
        return this.cpuProfilingAvailable;
    }

    @Override
    public final long getCurrentThreadCpuTime() {
        if (!this.cpuProfilingAvailable) {
            return Long.MIN_VALUE;
        }
        long rawResult = this.threadMXBean.getCurrentThreadCpuTime();
        return rawResult < 0L ? Long.MIN_VALUE : rawResult;
    }

    @Override
    public final long getCurrentThreadUserTime() {
        if (!this.cpuProfilingAvailable) {
            return Long.MIN_VALUE;
        }
        long rawResult = this.threadMXBean.getCurrentThreadUserTime();
        return rawResult < 0L ? Long.MIN_VALUE : rawResult;
    }
}

