/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.profiling;

import io.deephaven.configuration.Configuration;
import io.deephaven.util.profiling.BaselineThreadMXBeanThreadProfiler;
import io.deephaven.util.profiling.NullThreadProfiler;
import io.deephaven.util.profiling.SunThreadMXBeanThreadProfiler;

public interface ThreadProfiler {
    public static final boolean CPU_PROFILING_ENABLED = Configuration.getInstance().getBooleanForClassWithDefault(ThreadProfiler.class, "cpuProfilingEnabled", true);
    public static final boolean MEMORY_PROFILING_ENABLED = Configuration.getInstance().getBooleanForClassWithDefault(ThreadProfiler.class, "memoryProfilingEnabled", true);
    public static final ThreadProfiler DEFAULT = ThreadProfiler.make();

    public boolean memoryProfilingAvailable();

    public long getCurrentThreadAllocatedBytes();

    public boolean cpuProfilingAvailable();

    public long getCurrentThreadCpuTime();

    public long getCurrentThreadUserTime();

    public static ThreadProfiler make() {
        if (!CPU_PROFILING_ENABLED && !MEMORY_PROFILING_ENABLED) {
            return NullThreadProfiler.INSTANCE;
        }
        String vendor = System.getProperty("java.vendor");
        if (vendor.contains("Sun") || vendor.contains("Oracle") || vendor.contains("OpenJDK") || vendor.contains("Adoptium")) {
            return new SunThreadMXBeanThreadProfiler();
        }
        return new BaselineThreadMXBeanThreadProfiler();
    }
}

