/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.referencecounting;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.io.log.impl.LogOutputStringImpl;
import io.deephaven.util.Utils;
import java.io.ObjectInputStream;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jetbrains.annotations.NotNull;

public abstract class ReferenceCounted
implements LogOutputAppendable {
    private static final AtomicIntegerFieldUpdater<ReferenceCounted> REFERENCE_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ReferenceCounted.class, "referenceCount");
    private static final int INITIAL_ZERO_VALUE = -1;
    private static final int MAXIMUM_VALUE = -3;
    private static final int ONE_VALUE = 1;
    private static final int NORMAL_TERMINAL_ZERO_VALUE = 0;
    private static final int FORCED_TERMINAL_ZERO_VALUE = -2;
    private volatile transient int referenceCount;

    protected ReferenceCounted() {
        this(0);
    }

    protected ReferenceCounted(int initialValue) {
        this.initializeReferenceCount(initialValue);
    }

    private void readObject(@NotNull ObjectInputStream in) {
        this.initializeReferenceCount(0);
    }

    public String toString() {
        return new LogOutputStringImpl().append((LogOutputAppendable)this).toString();
    }

    public LogOutput append(LogOutput logOutput) {
        return logOutput.append(Utils.REFERENT_FORMATTER, (Object)this).append('[').append(this.getCurrentReferenceCount()).append(']');
    }

    private void initializeReferenceCount(int initialValue) {
        if (initialValue == -1 || initialValue == -2) {
            throw new IllegalArgumentException("Invalid initial reference count " + initialValue);
        }
        this.referenceCount = initialValue == 0 ? -1 : initialValue;
    }

    public static String getReferenceCountDebug(Object maybeReferenceCounted) {
        return maybeReferenceCounted instanceof ReferenceCounted ? Integer.toString(((ReferenceCounted)maybeReferenceCounted).getCurrentReferenceCount()) : "not reference counted";
    }

    private int getCurrentReferenceCount() {
        return this.referenceCount;
    }

    private boolean tryUpdateReferenceCount(int expected, int update) {
        return REFERENCE_COUNT_UPDATER.compareAndSet(this, expected, update);
    }

    public final void resetReferenceCount() {
        if (!this.tryUpdateReferenceCount(0, -1) && !this.tryUpdateReferenceCount(-2, -1)) {
            throw new IllegalStateException(Utils.makeReferentDescription(this) + "'s reference count is non-zero and cannot be reset");
        }
    }

    private static boolean isInitialZero(int countValue) {
        return countValue == -1;
    }

    private static boolean isTerminalZero(int countValue) {
        return countValue == 0 || countValue == -2;
    }

    private static boolean isZero(int countValue) {
        return ReferenceCounted.isInitialZero(countValue) || ReferenceCounted.isTerminalZero(countValue);
    }

    public final boolean tryIncrementReferenceCount() {
        int currentReferenceCount;
        while (!ReferenceCounted.isTerminalZero(currentReferenceCount = this.getCurrentReferenceCount())) {
            if (currentReferenceCount == -3) {
                throw new IllegalStateException(Utils.makeReferentDescription(this) + "'s reference count cannot exceed maximum value");
            }
            if (!this.tryUpdateReferenceCount(currentReferenceCount, ReferenceCounted.isInitialZero(currentReferenceCount) ? 1 : currentReferenceCount + 1)) continue;
            return true;
        }
        return false;
    }

    public final void incrementReferenceCount() {
        if (!this.tryIncrementReferenceCount()) {
            throw new IllegalStateException(Utils.makeReferentDescription(this) + "'s reference count has already reached zero");
        }
    }

    public final boolean tryDecrementReferenceCount() {
        int currentReferenceCount;
        while (!ReferenceCounted.isZero(currentReferenceCount = this.getCurrentReferenceCount())) {
            if (!this.tryUpdateReferenceCount(currentReferenceCount, currentReferenceCount - 1)) continue;
            if (currentReferenceCount == 1) {
                this.onReferenceCountAtZero();
            }
            return true;
        }
        return currentReferenceCount == -2;
    }

    public final boolean forceReferenceCountToZero() {
        int currentReferenceCount;
        while (!ReferenceCounted.isZero(currentReferenceCount = this.getCurrentReferenceCount())) {
            if (!this.tryUpdateReferenceCount(currentReferenceCount, -2)) continue;
            this.onReferenceCountAtZero();
            return true;
        }
        return false;
    }

    public final void decrementReferenceCount() {
        if (!this.tryDecrementReferenceCount()) {
            throw new IllegalStateException(Utils.makeReferentDescription(this) + "'s reference count has been decreased more than increased");
        }
    }

    protected abstract void onReferenceCountAtZero();
}

