/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.text;

import io.deephaven.datastructures.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class SplitIgnoreQuotes {
    private static final char QUOTE = '\"';
    private static final char BACK_TICK = '`';
    private SplitMode mode = SplitMode.NORMAL;
    private StringBuilder builder;
    private final List<String> values = new ArrayList<String>();

    public String[] split(String string, char splitter) {
        this.mode = SplitMode.NORMAL;
        this.builder = new StringBuilder();
        this.values.clear();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                this.processQuote(c);
                continue;
            }
            if (c == '`') {
                this.processBackTick(c);
                continue;
            }
            if (c == splitter) {
                this.processSplitter(c);
                continue;
            }
            this.processChar(c);
        }
        if (this.mode == SplitMode.IN_QUOTES) {
            throw new RuntimeException("Unmatched quote in expression " + string);
        }
        if (this.mode == SplitMode.IN_BACK_TICKS) {
            throw new RuntimeException("Unmatched back tick in expression " + string);
        }
        this.addCurrentValue();
        return this.values.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY);
    }

    private void processQuote(char c) {
        switch (this.mode) {
            case NORMAL: {
                this.mode = SplitMode.IN_QUOTES;
                break;
            }
            case IN_QUOTES: {
                this.mode = SplitMode.NORMAL;
            }
        }
        this.processChar(c);
    }

    private void processBackTick(char c) {
        switch (this.mode) {
            case NORMAL: {
                this.mode = SplitMode.IN_BACK_TICKS;
                break;
            }
            case IN_BACK_TICKS: {
                this.mode = SplitMode.NORMAL;
            }
        }
        this.processChar(c);
    }

    private void processSplitter(char c) {
        if (this.mode == SplitMode.IN_QUOTES || this.mode == SplitMode.IN_BACK_TICKS) {
            this.processChar(c);
        } else {
            this.addCurrentValue();
            this.builder = new StringBuilder();
        }
    }

    private void addCurrentValue() {
        String value = this.builder.toString().trim();
        if (!value.isEmpty()) {
            this.values.add(value);
        }
    }

    private void processChar(char c) {
        this.builder.append(c);
    }

    private static enum SplitMode {
        NORMAL,
        IN_QUOTES,
        IN_BACK_TICKS;

    }
}

