/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class NamingThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private final String name;
    private final Class<?> clazz;
    private final boolean daemon;
    private final ThreadGroup threadGroup;

    public NamingThreadFactory(Class<?> clazz, String name) {
        this(clazz, name, true);
    }

    public NamingThreadFactory(Class<?> clazz, String name, boolean daemon) {
        this(null, clazz, name, daemon);
    }

    public NamingThreadFactory(ThreadGroup threadGroup, Class<?> clazz, String name, boolean daemon) {
        this.threadGroup = threadGroup;
        this.clazz = clazz;
        this.name = name;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        Thread thread = new Thread(this.threadGroup, r, this.clazz.getSimpleName() + "-" + this.name + "-" + this.threadCounter.incrementAndGet());
        thread.setDaemon(this.daemon);
        return thread;
    }
}

