/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.thread;

import io.deephaven.base.log.LogOutput;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.impl.LogOutputStringImpl;
import io.deephaven.io.logger.Logger;
import java.io.PrintStream;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Objects;

public class ThreadDump {
    private static final LogOutput.ObjFormatter<ThreadInfo> THREAD_INFO_OBJ_FORMATTER = (logOutput, threadInfo) -> {
        if (threadInfo == null) {
            logOutput.append((CharSequence)"null");
            return;
        }
        logOutput.append((CharSequence)"\"").append((CharSequence)threadInfo.getThreadName()).append((CharSequence)"\" Id=").append(threadInfo.getThreadId()).append((CharSequence)" ").append((CharSequence)Objects.toString((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            logOutput.append((CharSequence)" on ").append((CharSequence)threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            logOutput.append((CharSequence)" owned by \"").append((CharSequence)threadInfo.getLockOwnerName()).append((CharSequence)"\" Id=").append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            logOutput.append((CharSequence)" (suspended)");
        }
        if (threadInfo.isInNative()) {
            logOutput.append((CharSequence)" (in native)");
        }
        logOutput.append('\n');
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            logOutput.append((CharSequence)"\tat ").append((CharSequence)ste.toString());
            logOutput.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        logOutput.append((CharSequence)"\t-  blocked on ").append((CharSequence)Objects.toString(threadInfo.getLockInfo()));
                        logOutput.append('\n');
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        logOutput.append((CharSequence)"\t-  waiting on ").append((CharSequence)Objects.toString(threadInfo.getLockInfo()));
                        logOutput.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : threadInfo.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                logOutput.append((CharSequence)"\t-  locked ").append((CharSequence)Objects.toString(lockInfo));
                logOutput.append('\n');
            }
        }
        LockInfo[] locks = threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            logOutput.append((CharSequence)"\n\tNumber of locked synchronizers = ").append(locks.length);
            logOutput.append('\n');
            for (LockInfo lockInfo : locks) {
                logOutput.append((CharSequence)"\t- ").append((CharSequence)Objects.toString(lockInfo));
                logOutput.append('\n');
            }
        }
        logOutput.append('\n');
    };

    public static void threadDump(PrintStream out) {
        out.print(ThreadDump.threadDump());
    }

    public static void threadDump(Logger logger) {
        ThreadInfo[] threadInfos;
        for (ThreadInfo threadInfo : threadInfos = ThreadDump.getThreadInfos()) {
            LogEntry info = logger.info();
            info.append(THREAD_INFO_OBJ_FORMATTER, (Object)threadInfo);
            info.end();
        }
    }

    public static String threadDump() {
        ThreadInfo[] threadInfos;
        LogOutputStringImpl lo = new LogOutputStringImpl();
        for (ThreadInfo threadInfo : threadInfos = ThreadDump.getThreadInfos()) {
            lo.append(THREAD_INFO_OBJ_FORMATTER, (Object)threadInfo);
        }
        return lo.toString();
    }

    private static ThreadInfo[] getThreadInfos() {
        ThreadMXBean threadMXBean = ManagementFactory.getPlatformMXBean(ThreadMXBean.class);
        return threadMXBean.dumpAllThreads(true, true);
    }
}

